/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package alluxio.shaded.client.org.apache.zookeeper.cli;

import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.cli.CommandLine;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.cli.Options;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.cli.ParseException;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.cli.Parser;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.cli.PosixParser;
import alluxio.shaded.client.org.apache.zookeeper.AsyncCallback;

/**
 * sync alluxio.shaded.client.com.and for cli
 */
public class SyncCommand extends CliCommand {

    private static Options options = new Options();
    private String[] args;

    public SyncCommand() {
        super("sync", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        Parser parser = new PosixParser();
        CommandLine cl;
        try {
            cl = parser.parse(options, cmdArgs);
        } catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        args = cl.getArgs();
        if (args.length < 2) {
            throw new CliParseException(getUsageStr());
        }

        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = args[1];
        try {
            zk.sync(path, new AsyncCallback.VoidCallback() {

                public void processResult(int rc, String path, Object ctx) {
                    out.println("Sync returned " + rc);
                }
            }, null);
        } catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }


        return false;
    }
}
