/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.grpc.TtlAction;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.BlockInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import java.util.List;
import java.util.Set;

@ThreadSafe
public class URIStatus {
    private final FileInfo mInfo;

    public URIStatus(FileInfo info) {
        this.mInfo = Preconditions.checkNotNull(info, "Cannot create a URIStatus from a null FileInfo");
    }

    public AccessControlList getAcl() {
        return this.mInfo.getAcl();
    }

    public DefaultAccessControlList getDefaultAcl() {
        return this.mInfo.getDefaultAcl();
    }

    @Nullable
    public BlockInfo getBlockInfo(long blockId) {
        FileBlockInfo info = this.mInfo.getFileBlockInfo(blockId);
        return info == null ? null : info.getBlockInfo();
    }

    public List<Long> getBlockIds() {
        return this.mInfo.getBlockIds();
    }

    public long getBlockSizeBytes() {
        return this.mInfo.getBlockSizeBytes();
    }

    public long getCreationTimeMs() {
        return this.mInfo.getCreationTimeMs();
    }

    public long getFileId() {
        return this.mInfo.getFileId();
    }

    public String getGroup() {
        return this.mInfo.getGroup();
    }

    public int getInMemoryPercentage() {
        return this.mInfo.getInMemoryPercentage();
    }

    public int getInAlluxioPercentage() {
        return this.mInfo.getInAlluxioPercentage();
    }

    public long getLastModificationTimeMs() {
        return this.mInfo.getLastModificationTimeMs();
    }

    public long getLastAccessTimeMs() {
        return this.mInfo.getLastAccessTimeMs();
    }

    public long getLength() {
        return this.mInfo.getLength();
    }

    public String getName() {
        return this.mInfo.getName();
    }

    public String getPath() {
        return this.mInfo.getPath();
    }

    public int getMode() {
        return this.mInfo.getMode();
    }

    public String getPersistenceState() {
        return this.mInfo.getPersistenceState();
    }

    public long getTtl() {
        return this.mInfo.getTtl();
    }

    public TtlAction getTtlAction() {
        return this.mInfo.getTtlAction();
    }

    public String getUfsPath() {
        return this.mInfo.getUfsPath();
    }

    public String getOwner() {
        return this.mInfo.getOwner();
    }

    public int getReplicationMax() {
        return this.mInfo.getReplicationMax();
    }

    public int getReplicationMin() {
        return this.mInfo.getReplicationMin();
    }

    public boolean isCacheable() {
        return this.mInfo.isCacheable();
    }

    public boolean isCompleted() {
        return this.mInfo.isCompleted();
    }

    public boolean isFolder() {
        return this.mInfo.isFolder();
    }

    public boolean isPersisted() {
        return this.mInfo.isPersisted();
    }

    public boolean isPinned() {
        return this.mInfo.isPinned();
    }

    public Set<String> getPinnedMediumTypes() {
        return this.mInfo.getMediumTypes();
    }

    public boolean isMountPoint() {
        return this.mInfo.isMountPoint();
    }

    public long getMountId() {
        return this.mInfo.getMountId();
    }

    public List<FileBlockInfo> getFileBlockInfos() {
        return this.mInfo.getFileBlockInfos();
    }

    public String getUfsFingerprint() {
        return this.mInfo.getUfsFingerprint();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URIStatus)) {
            return false;
        }
        URIStatus that = (URIStatus)o;
        return this.mInfo.equals(that.mInfo);
    }

    public int hashCode() {
        return this.mInfo.hashCode();
    }

    public String toString() {
        return this.mInfo.toString();
    }
}

