/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.opencensus.trace.config;

import alluxio.shaded.client.io.opencensus.internal.Utils;
import alluxio.shaded.client.io.opencensus.trace.Sampler;
import alluxio.shaded.client.io.opencensus.trace.config.AutoValue_TraceParams;
import alluxio.shaded.client.io.opencensus.trace.samplers.Samplers;
import alluxio.shaded.client.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TraceParams {
    private static final double DEFAULT_PROBABILITY = 1.0E-4;
    private static final Sampler DEFAULT_SAMPLER = Samplers.probabilitySampler(1.0E-4);
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ANNOTATIONS = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_MESSAGE_EVENTS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 32;
    public static final TraceParams DEFAULT = TraceParams.builder().setSampler(DEFAULT_SAMPLER).setMaxNumberOfAttributes(32).setMaxNumberOfAnnotations(32).setMaxNumberOfMessageEvents(128).setMaxNumberOfLinks(32).build();

    public abstract Sampler getSampler();

    public abstract int getMaxNumberOfAttributes();

    public abstract int getMaxNumberOfAnnotations();

    public abstract int getMaxNumberOfMessageEvents();

    @Deprecated
    public int getMaxNumberOfNetworkEvents() {
        return this.getMaxNumberOfMessageEvents();
    }

    public abstract int getMaxNumberOfLinks();

    private static Builder builder() {
        return new AutoValue_TraceParams.Builder();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder setSampler(Sampler var1);

        public abstract Builder setMaxNumberOfAttributes(int var1);

        public abstract Builder setMaxNumberOfAnnotations(int var1);

        public abstract Builder setMaxNumberOfMessageEvents(int var1);

        @Deprecated
        public Builder setMaxNumberOfNetworkEvents(int maxNumberOfNetworkEvents) {
            return this.setMaxNumberOfMessageEvents(maxNumberOfNetworkEvents);
        }

        public abstract Builder setMaxNumberOfLinks(int var1);

        abstract TraceParams autoBuild();

        public TraceParams build() {
            TraceParams traceParams = this.autoBuild();
            Utils.checkArgument(traceParams.getMaxNumberOfAttributes() > 0, "maxNumberOfAttributes");
            Utils.checkArgument(traceParams.getMaxNumberOfAnnotations() > 0, "maxNumberOfAnnotations");
            Utils.checkArgument(traceParams.getMaxNumberOfMessageEvents() > 0, "maxNumberOfMessageEvents");
            Utils.checkArgument(traceParams.getMaxNumberOfLinks() > 0, "maxNumberOfLinks");
            return traceParams;
        }
    }
}

