/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public final class UnderFileSystemConfiguration
extends InstancedConfiguration {
    private boolean mReadOnly = false;
    private boolean mShared = false;

    public static UnderFileSystemConfiguration defaults(AlluxioConfiguration alluxioConf) {
        return new UnderFileSystemConfiguration(alluxioConf.copyProperties());
    }

    private UnderFileSystemConfiguration(AlluxioProperties props) {
        super(props);
    }

    public Map<String, String> getMountSpecificConf() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.keySet().forEach(key -> {
            if (this.getSource((PropertyKey)key) == Source.MOUNT_OPTION) {
                map.put(key.getName(), this.get((PropertyKey)key));
            }
        });
        return map;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public boolean isShared() {
        return this.mShared;
    }

    public UnderFileSystemConfiguration setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
        return this;
    }

    public UnderFileSystemConfiguration setShared(boolean shared) {
        this.mShared = shared;
        return this;
    }

    public UnderFileSystemConfiguration createMountSpecificConf(Map<String, String> mountConf) {
        UnderFileSystemConfiguration ufsConf = new UnderFileSystemConfiguration(this.mProperties.copy());
        ufsConf.mProperties.merge(mountConf, Source.MOUNT_OPTION);
        ufsConf.mReadOnly = this.mReadOnly;
        ufsConf.mShared = this.mShared;
        return ufsConf;
    }

    public Map<String, String> toUserPropertyMap(ConfigurationValueOptions options) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.userKeySet().forEach(key -> map.put(key.getName(), this.getOrDefault((PropertyKey)key, null, options)));
        return map;
    }
}

