/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.AlluxioURI;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileInStream;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.OpenFilePOptions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheFileSystem
extends DelegatingFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheFileSystem.class);
    private static Optional<CacheManager> sCacheManager;
    private final AlluxioConfiguration mConf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="write to static is made threadsafe")
    public LocalCacheFileSystem(FileSystem fs, AlluxioConfiguration conf) {
        super(fs);
        if (sCacheManager == null) {
            Class<LocalCacheFileSystem> clazz = LocalCacheFileSystem.class;
            // MONITORENTER : alluxio.client.file.cache.LocalCacheFileSystem.class
            if (sCacheManager == null) {
                try {
                    sCacheManager = Optional.of(CacheManager.create(conf));
                }
                catch (IOException e) {
                    LOG.warn("Failed to create CacheManager: {}", (Object)e.toString());
                    sCacheManager = Optional.empty();
                }
            }
            // MONITOREXIT : clazz
        }
        this.mConf = conf;
    }

    @Override
    public AlluxioConfiguration getConf() {
        return this.mDelegatedFileSystem.getConf();
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws IOException, AlluxioException {
        if (sCacheManager == null || !sCacheManager.isPresent()) {
            return this.mDelegatedFileSystem.openFile(path, options);
        }
        return new LocalCacheFileInStream(path, options, this.mDelegatedFileSystem, sCacheManager.get());
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws IOException, AlluxioException {
        if (sCacheManager == null || !sCacheManager.isPresent()) {
            return this.mDelegatedFileSystem.openFile(status, options);
        }
        return new LocalCacheFileInStream(status, options, this.mDelegatedFileSystem, sCacheManager.get());
    }
}

