/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcManagedChannelPool;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.ClientInterceptors;
import alluxio.shaded.client.io.grpc.ForwardingClientCall;
import alluxio.shaded.client.io.grpc.ForwardingClientCallListener;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GrpcChannel
extends Channel {
    private final GrpcChannelKey mChannelKey;
    private final Channel mOriginalChannel;
    private final long mShutdownTimeoutMs;
    private Channel mTrackedChannel;
    private ChannelResponseTracker mResponseTracker;
    private AuthenticatedChannelClientDriver mAuthDriver;
    private boolean mChannelReleased = false;

    public GrpcChannel(GrpcChannelKey channelKey, Channel channel, long shutdownTimeoutMs, @Nullable AuthenticatedChannelClientDriver authDriver) {
        this.mChannelKey = channelKey;
        this.mShutdownTimeoutMs = shutdownTimeoutMs;
        this.mOriginalChannel = channel;
        this.mAuthDriver = authDriver;
        this.mResponseTracker = new ChannelResponseTracker();
        this.mTrackedChannel = ClientInterceptors.intercept(this.mOriginalChannel, this.mResponseTracker);
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.mTrackedChannel.newCall(methodDescriptor, callOptions);
    }

    @Override
    public String authority() {
        return this.mTrackedChannel.authority();
    }

    public void intercept(ClientInterceptor interceptor) {
        this.mTrackedChannel = ClientInterceptors.intercept(this.mTrackedChannel, interceptor);
    }

    public synchronized void shutdown() {
        if (this.mAuthDriver != null) {
            this.mAuthDriver.close();
            this.mAuthDriver = null;
        }
        if (!this.mChannelReleased) {
            GrpcManagedChannelPool.INSTANCE().releaseManagedChannel(this.mChannelKey, this.mShutdownTimeoutMs);
            this.mChannelReleased = true;
        }
    }

    public boolean isShutdown() {
        return this.mChannelReleased;
    }

    public boolean isHealthy() {
        boolean healthy = this.mResponseTracker.isChannelHealthy();
        if (this.mAuthDriver != null) {
            healthy &= this.mAuthDriver.isAuthenticated();
        }
        return healthy;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ChannelKey", this.mChannelKey).add("ChannelHealthy", this.isHealthy()).add("ChannelReleased", this.mChannelReleased).toString();
    }

    public String toStringShort() {
        return this.mChannelKey.toStringShort();
    }

    private class ChannelResponseTracker
    implements ClientInterceptor {
        private boolean mChannelHealthy = true;

        private ChannelResponseTracker() {
        }

        public boolean isChannelHealthy() {
            return this.mChannelHealthy;
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            if (status == Status.UNAUTHENTICATED || status == Status.UNAVAILABLE) {
                                ChannelResponseTracker.this.mChannelHealthy = false;
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

