/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcManagedChannelPool;
import alluxio.grpc.GrpcServerAddress;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import alluxio.security.authentication.ChannelAuthenticator;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;

public final class GrpcChannelBuilder {
    private final GrpcChannelKey mChannelKey;
    private Subject mParentSubject;
    private boolean mAuthenticateChannel;
    private final AuthType mAuthType;
    private final long mShutdownTimeoutMs;
    private final long mHealthCheckTimeoutMs;
    private AlluxioConfiguration mConfiguration;

    private GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        this.mConfiguration = conf;
        this.mAuthType = this.mConfiguration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        this.mShutdownTimeoutMs = this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT);
        this.mHealthCheckTimeoutMs = this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT);
        this.mChannelKey = GrpcChannelKey.create(conf);
        this.mChannelKey.setServerAddress(address);
        this.mChannelKey.setMaxInboundMessageSize((int)this.mConfiguration.getBytes(PropertyKey.USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE));
        this.mAuthenticateChannel = this.mAuthType != AuthType.NOSASL;
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        return new GrpcChannelBuilder(address, conf);
    }

    public GrpcChannelBuilder setClientType(String clientType) {
        this.mChannelKey.setClientType(clientType);
        return this;
    }

    public GrpcChannelBuilder setSubject(Subject subject) {
        this.mParentSubject = subject;
        return this;
    }

    public GrpcChannelBuilder disableAuthentication() {
        this.mAuthenticateChannel = false;
        return this;
    }

    public GrpcChannelBuilder setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.mChannelKey.setKeepAliveTime(keepAliveTime, timeUnit);
        return this;
    }

    public GrpcChannelBuilder setKeepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.mChannelKey.setKeepAliveTimeout(keepAliveTimeout, timeUnit);
        return this;
    }

    public GrpcChannelBuilder setMaxInboundMessageSize(int maxInboundMessaageSize) {
        this.mChannelKey.setMaxInboundMessageSize(maxInboundMessaageSize);
        return this;
    }

    public GrpcChannelBuilder setFlowControlWindow(int flowControlWindow) {
        this.mChannelKey.setFlowControlWindow(flowControlWindow);
        return this;
    }

    public GrpcChannelBuilder setChannelType(Class<? extends Channel> channelType) {
        this.mChannelKey.setChannelType(channelType);
        return this;
    }

    public GrpcChannelBuilder setEventLoopGroup(EventLoopGroup group) {
        this.mChannelKey.setEventLoopGroup(group);
        return this;
    }

    public GrpcChannelBuilder setPoolingStrategy(GrpcChannelKey.PoolingStrategy strategy) {
        this.mChannelKey.setPoolingStrategy(strategy);
        return this;
    }

    public GrpcChannel build() throws AlluxioStatusException {
        ManagedChannel managedChannel = GrpcManagedChannelPool.INSTANCE().acquireManagedChannel(this.mChannelKey, this.mHealthCheckTimeoutMs, this.mShutdownTimeoutMs);
        try {
            alluxio.shaded.client.io.grpc.Channel logicalChannel = managedChannel;
            AuthenticatedChannelClientDriver authDriver = null;
            if (this.mAuthenticateChannel) {
                ChannelAuthenticator channelAuthenticator = new ChannelAuthenticator(this.mChannelKey, managedChannel, this.mParentSubject, this.mAuthType, this.mConfiguration);
                channelAuthenticator.authenticate();
                logicalChannel = channelAuthenticator.getAuthenticatedChannel();
                authDriver = channelAuthenticator.getAuthenticationDriver();
            }
            return new GrpcChannel(this.mChannelKey, logicalChannel, this.mShutdownTimeoutMs, authDriver);
        }
        catch (Throwable t) {
            GrpcManagedChannelPool.INSTANCE().releaseManagedChannel(this.mChannelKey, this.mShutdownTimeoutMs);
            if (t instanceof UnavailableException) {
                throw new UnavailableException(String.format("Target Unavailable. %s", this.mChannelKey.toStringShort()), t.getCause());
            }
            throw AlluxioStatusException.fromThrowable(t);
        }
    }
}

