/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.user;

import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.User;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.base.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUserState
implements UserState {
    private static final Logger LOG = LoggerFactory.getLogger(BaseUserState.class);
    protected final Subject mSubject;
    protected volatile User mUser;
    protected AlluxioConfiguration mConf;

    public BaseUserState(Subject subject, AlluxioConfiguration conf) {
        this.mSubject = subject;
        this.mConf = conf;
        this.mUser = this.getUserFromSubject();
    }

    @Override
    public Subject getSubject() {
        try {
            this.tryLogin();
        }
        catch (UnauthenticatedException e) {
            LOG.warn("Subject login failed: {}", (Object)e.getMessage());
        }
        return this.mSubject;
    }

    @Override
    public User getUser() throws UnauthenticatedException {
        this.tryLogin();
        return this.mUser;
    }

    protected abstract User login() throws UnauthenticatedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLogin() throws UnauthenticatedException {
        if (this.mUser == null) {
            BaseUserState baseUserState = this;
            synchronized (baseUserState) {
                if (this.mUser == null) {
                    this.mUser = this.login();
                }
            }
        }
    }

    private User getUserFromSubject() {
        Set<User> userSet = this.mSubject.getPrincipals(User.class);
        if (userSet.isEmpty()) {
            return null;
        }
        return userSet.iterator().next();
    }

    @Override
    public User relogin() throws UnauthenticatedException {
        this.tryLogin();
        return this.mUser;
    }

    public int hashCode() {
        return Objects.hashCode(this.mSubject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BaseUserState that = (BaseUserState)o;
        return Objects.equal(this.mSubject, that.mSubject);
    }
}

