/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.netty.channel.epoll;

import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.io.netty.channel.EventLoopTaskQueueFactory;
import alluxio.shaded.client.io.netty.channel.SelectStrategy;
import alluxio.shaded.client.io.netty.channel.SingleThreadEventLoop;
import alluxio.shaded.client.io.netty.channel.epoll.AbstractEpollChannel;
import alluxio.shaded.client.io.netty.channel.epoll.Epoll;
import alluxio.shaded.client.io.netty.channel.epoll.EpollEventArray;
import alluxio.shaded.client.io.netty.channel.epoll.Native;
import alluxio.shaded.client.io.netty.channel.epoll.NativeDatagramPacketArray;
import alluxio.shaded.client.io.netty.channel.unix.FileDescriptor;
import alluxio.shaded.client.io.netty.channel.unix.IovArray;
import alluxio.shaded.client.io.netty.util.IntSupplier;
import alluxio.shaded.client.io.netty.util.collection.IntObjectHashMap;
import alluxio.shaded.client.io.netty.util.collection.IntObjectMap;
import alluxio.shaded.client.io.netty.util.concurrent.RejectedExecutionHandler;
import alluxio.shaded.client.io.netty.util.internal.ObjectUtil;
import alluxio.shaded.client.io.netty.util.internal.PlatformDependent;
import alluxio.shaded.client.io.netty.util.internal.logging.InternalLogger;
import alluxio.shaded.client.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.BitSet;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private long prevDeadlineNanos = EpollEventLoop.nanoTime() - 1L;
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap<AbstractEpollChannel>(4096);
    private final BitSet pendingFlagChannels = new BitSet();
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private IovArray iovArray;
    private NativeDatagramPacketArray datagramPacketArray;
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return EpollEventLoop.this.epollWaitNow();
        }
    };
    private final AtomicInteger wakenUp = new AtomicInteger(1);
    private boolean pendingWakeup;
    private volatile int ioRatio = 50;
    private static final long MAX_SCHEDULED_TIMERFD_NS = 999999999L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpollEventLoop(EventLoopGroup parent, Executor executor, int maxEvents, SelectStrategy strategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory queueFactory) {
        super(parent, executor, false, EpollEventLoop.newTaskQueue(queueFactory), EpollEventLoop.newTaskQueue(queueFactory), rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(strategy, "strategy");
        if (maxEvents == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(maxEvents);
        }
        boolean success = false;
        FileDescriptor epollFd = null;
        FileDescriptor eventFd = null;
        FileDescriptor timerFd = null;
        try {
            this.epollFd = epollFd = Native.newEpollCreate();
            this.eventFd = eventFd = Native.newEventFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), eventFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", e);
            }
            this.timerFd = timerFd = Native.newTimerFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), timerFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", e);
            }
            success = true;
        }
        finally {
            if (!success) {
                if (epollFd != null) {
                    try {
                        epollFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (eventFd != null) {
                    try {
                        eventFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (timerFd != null) {
                    try {
                        timerFd.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory queueFactory) {
        if (queueFactory == null) {
            return EpollEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return queueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    IovArray cleanIovArray() {
        if (this.iovArray == null) {
            this.iovArray = new IovArray();
        } else {
            this.iovArray.clear();
        }
        return this.iovArray;
    }

    NativeDatagramPacketArray cleanDatagramPacketArray() {
        if (this.datagramPacketArray == null) {
            this.datagramPacketArray = new NativeDatagramPacketArray();
        } else {
            this.datagramPacketArray.clear();
        }
        return this.datagramPacketArray;
    }

    @Override
    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop && this.wakenUp.getAndSet(1) == 0) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    void add(AbstractEpollChannel ch) throws IOException {
        assert (this.inEventLoop());
        int fd = ch.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), fd, ch.flags);
        ch.activeFlags = ch.flags;
        AbstractEpollChannel old = this.channels.put(fd, ch);
        assert (old == null || !old.isOpen());
    }

    void modify(AbstractEpollChannel ch) throws IOException {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), ch.socket.intValue(), ch.flags);
        ch.activeFlags = ch.flags;
    }

    void updatePendingFlagsSet(AbstractEpollChannel ch) {
        this.pendingFlagChannels.set(ch.socket.intValue(), ch.flags != ch.activeFlags);
    }

    private void processPendingChannelFlags() {
        if (!this.pendingFlagChannels.isEmpty()) {
            int fd = 0;
            while ((fd = this.pendingFlagChannels.nextSetBit(fd)) >= 0) {
                AbstractEpollChannel ch = this.channels.get(fd);
                if (ch != null) {
                    try {
                        ch.modifyEvents();
                    }
                    catch (IOException e) {
                        ch.pipeline().fireExceptionCaught(e);
                        ch.close();
                    }
                }
                this.pendingFlagChannels.clear(fd);
            }
        }
    }

    void remove(AbstractEpollChannel ch) throws IOException {
        assert (this.inEventLoop());
        int fd = ch.socket.intValue();
        AbstractEpollChannel old = this.channels.remove(fd);
        if (old != null && old != ch) {
            this.channels.put(fd, old);
            assert (!ch.isOpen());
        } else {
            ch.activeFlags = 0;
            this.pendingFlagChannels.clear(fd);
            if (ch.isOpen()) {
                Native.epollCtlDel(this.epollFd.intValue(), fd);
            }
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return EpollEventLoop.newTaskQueue0(maxPendingTasks);
    }

    private static Queue<Runnable> newTaskQueue0(int maxPendingTasks) {
        return maxPendingTasks == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(maxPendingTasks);
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int ioRatio) {
        if (ioRatio <= 0 || ioRatio > 100) {
            throw new IllegalArgumentException("ioRatio: " + ioRatio + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = ioRatio;
    }

    @Override
    public int registeredChannels() {
        return this.channels.size();
    }

    private int epollWait() throws IOException {
        int delayNanos;
        int delaySeconds;
        long curDeadlineNanos = this.deadlineNanos();
        if (curDeadlineNanos == this.prevDeadlineNanos) {
            delaySeconds = -1;
            delayNanos = -1;
        } else {
            long totalDelay = this.delayNanos(System.nanoTime());
            this.prevDeadlineNanos = curDeadlineNanos;
            delaySeconds = (int)Math.min(totalDelay / 1000000000L, Integer.MAX_VALUE);
            delayNanos = (int)Math.min(totalDelay - (long)delaySeconds * 1000000000L, 999999999L);
        }
        return Native.epollWait(this.epollFd, this.events, this.timerFd, delaySeconds, delayNanos);
    }

    private int epollWaitNow() throws IOException {
        return Native.epollWait(this.epollFd, this.events, true);
    }

    private int epollBusyWait() throws IOException {
        return Native.epollBusyWait(this.epollFd, this.events);
    }

    private int epollWaitTimeboxed() throws IOException {
        return Native.epollWait(this.epollFd, this.events, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void run() {
        while (true) {
            try {
                block18: while (true) {
                    this.processPendingChannelFlags();
                    strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (strategy) {
                        case -2: {
                            continue block18;
                        }
                        case -3: {
                            strategy = this.epollBusyWait();
                            break block18;
                        }
                        case -1: {
                            if (this.pendingWakeup) {
                                strategy = this.epollWaitTimeboxed();
                                if (strategy != 0) break block18;
                                EpollEventLoop.logger.warn("Missed eventfd write (not seen after > 1 second)");
                                this.pendingWakeup = false;
                                if (this.hasTasks()) break block18;
                            }
                            this.wakenUp.set(0);
                            try {
                                if (!this.hasTasks()) {
                                    strategy = this.epollWait();
                                }
                                if (this.wakenUp.get() != 1 && this.wakenUp.getAndSet(1) != 1) break block18;
                                this.pendingWakeup = true;
                                break block18;
                            }
                            catch (Throwable var2_5) {
                                if (this.wakenUp.get() == 1 || this.wakenUp.getAndSet(1) == 1) {
                                    this.pendingWakeup = true;
                                }
                                throw var2_5;
                            }
                        }
                    }
                    break;
                }
                ioRatio = this.ioRatio;
                if (ioRatio == 100) {
                    try {
                        if (strategy <= 0) ** GOTO lbl50
                        this.processReady(this.events, strategy);
                    }
                    finally {
                        this.runAllTasks();
                    }
                } else {
                    ioStartTime = System.nanoTime();
                    try {
                        if (strategy > 0) {
                            this.processReady(this.events, strategy);
                        }
                    }
                    finally {
                        ioTime = System.nanoTime() - ioStartTime;
                        this.runAllTasks(ioTime * (long)(100 - ioRatio) / (long)ioRatio);
                    }
                }
                if (this.allowGrowing && strategy == this.events.length()) {
                    this.events.increase();
                }
            }
            catch (Throwable t) {
                this.handleLoopException(t);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
            }
            catch (Throwable t) {
                this.handleLoopException(t);
                continue;
            }
            break;
        }
    }

    void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void closeAll() {
        AbstractEpollChannel[] localChannels;
        try {
            this.epollWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (AbstractEpollChannel ch : localChannels = this.channels.values().toArray(new AbstractEpollChannel[0])) {
            ch.unsafe().close(ch.unsafe().voidPromise());
        }
    }

    private void processReady(EpollEventArray events, int ready) {
        for (int i = 0; i < ready; ++i) {
            int fd = events.fd(i);
            if (fd == this.eventFd.intValue()) {
                this.pendingWakeup = false;
                continue;
            }
            if (fd == this.timerFd.intValue()) continue;
            long ev = events.events(i);
            AbstractEpollChannel ch = this.channels.get(fd);
            if (ch != null) {
                AbstractEpollChannel.AbstractEpollUnsafe unsafe = (AbstractEpollChannel.AbstractEpollUnsafe)ch.unsafe();
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    unsafe.epollOutReady();
                }
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    unsafe.epollInReady();
                }
                if ((ev & (long)Native.EPOLLRDHUP) == 0L) continue;
                unsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), fd);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void cleanup() {
        try {
            block11: while (this.pendingWakeup) {
                try {
                    int count = this.epollWaitTimeboxed();
                    if (count == 0) break;
                    for (int i = 0; i < count; ++i) {
                        if (this.events.fd(i) != this.eventFd.intValue()) continue;
                        this.pendingWakeup = false;
                        continue block11;
                    }
                }
                catch (IOException count) {
                }
            }
            try {
                this.eventFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the event fd.", e);
            }
            try {
                this.timerFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the timer fd.", e);
            }
            try {
                this.epollFd.close();
                return;
            }
            catch (IOException e) {
                logger.warn("Failed to close the epoll fd.", e);
                return;
            }
        }
        finally {
            if (this.iovArray != null) {
                this.iovArray.release();
                this.iovArray = null;
            }
            if (this.datagramPacketArray != null) {
                this.datagramPacketArray.release();
                this.datagramPacketArray = null;
            }
            this.events.free();
        }
    }

    static {
        Epoll.ensureAvailability();
    }
}

