/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.LocalCacheManager;
import alluxio.client.file.cache.NoExceptionCacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.conf.AlluxioConfiguration;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheManager
extends AutoCloseable {
    public boolean put(PageId var1, byte[] var2);

    default public int get(PageId pageId, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        return this.get(pageId, 0, bytesToRead, buffer, offsetInBuffer);
    }

    public int get(PageId var1, int var2, int var3, byte[] var4, int var5);

    public boolean delete(PageId var1);

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private static CacheManager sCacheManager = null;

        public static synchronized CacheManager get(AlluxioConfiguration conf) throws IOException {
            if (sCacheManager == null) {
                sCacheManager = Factory.create(conf);
            }
            return sCacheManager;
        }

        static CacheManager create(AlluxioConfiguration conf) throws IOException {
            try {
                return new NoExceptionCacheManager(LocalCacheManager.create(conf));
            }
            catch (IOException e) {
                Metrics.CREATE_ERRORS.inc();
                LOG.error("Failed to create CacheManager", (Throwable)e);
                throw e;
            }
        }

        private Factory() {
        }

        private static final class Metrics {
            private static final Counter CREATE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_CREATE_ERRORS.getName());

            private Metrics() {
            }
        }
    }
}

