/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.MetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.exception.PageNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultMetaStore
implements MetaStore {
    private final Map<PageId, PageInfo> mPageMap = new HashMap<PageId, PageInfo>();
    private final AtomicLong mBytes = new AtomicLong(0L);
    private final AtomicLong mPages = new AtomicLong(0L);

    @Override
    public boolean hasPage(PageId pageId) {
        return this.mPageMap.containsKey(pageId);
    }

    @Override
    public void addPage(PageId pageId, PageInfo pageInfo) {
        this.mPageMap.put(pageId, pageInfo);
        this.mBytes.addAndGet(pageInfo.getPageSize());
        this.mPages.incrementAndGet();
    }

    @Override
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        if (!this.mPageMap.containsKey(pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        return this.mPageMap.get(pageId);
    }

    @Override
    public void removePage(PageId pageId) throws PageNotFoundException {
        if (!this.mPageMap.containsKey(pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = this.mPageMap.remove(pageId);
        this.mBytes.addAndGet(-pageInfo.getPageSize());
        this.mPages.decrementAndGet();
    }

    @Override
    public long bytes() {
        return this.mBytes.get();
    }

    @Override
    public long pages() {
        return this.mPages.get();
    }

    @Override
    public void reset() {
        this.mPages.set(0L);
        this.mBytes.set(0L);
        this.mPageMap.clear();
    }
}

