/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheEvictor;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.MetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.collections.ConcurrentHashSet;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.LockResource;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LocalCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheManager.class);
    private static final int LOCK_SIZE = 1024;
    private final long mPageSize;
    private final long mCacheSize;
    private final boolean mAsyncWrite;
    private final CacheEvictor mEvictor;
    private final ReadWriteLock[] mPageLocks = new ReentrantReadWriteLock[1024];
    private final PageStore mPageStore;
    private final ReadWriteLock mMetaLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mMetaLock")
    private final MetaStore mMetaStore;
    private final ExecutorService mAsyncCacheExecutor;
    private final ConcurrentHashSet<PageId> mPendingRequests;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean restore(PageStore pageStore, PageStoreOptions options, MetaStore metaStore, CacheEvictor evictor) {
        LOG.info("Attempt to restore PageStore with {}", (Object)options);
        Path rootDir = Paths.get(options.getRootDir(), new String[0]);
        if (!Files.exists(rootDir, new LinkOption[0])) {
            LOG.error("Failed to restore PageStore: Directory {} does not exist", (Object)rootDir);
            return false;
        }
        try (Stream<PageInfo> stream = pageStore.getPages();){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                PageInfo pageInfo = (PageInfo)iterator.next();
                if (pageInfo == null) {
                    LOG.error("Invalid page info");
                    boolean bl = false;
                    return bl;
                }
                metaStore.addPage(pageInfo.getPageId(), pageInfo);
                evictor.updateOnPut(pageInfo.getPageId());
                if (metaStore.bytes() <= pageStore.getCacheSize()) continue;
                LOG.error("Loaded pages exceed cache capacity ({} bytes)", (Object)pageStore.getCacheSize());
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to restore PageStore", (Throwable)e);
            return false;
        }
        LOG.info("Restored PageStore with {} existing pages and {} bytes", (Object)metaStore.pages(), (Object)metaStore.bytes());
        return true;
    }

    public static LocalCacheManager create(AlluxioConfiguration conf) throws IOException {
        MetaStore metaStore = MetaStore.create();
        CacheEvictor evictor = CacheEvictor.create(conf);
        PageStoreOptions options = PageStoreOptions.create(conf);
        PageStore pageStore = null;
        boolean restored = false;
        try {
            pageStore = PageStore.create(options, false);
            restored = LocalCacheManager.restore(pageStore, options, metaStore, evictor);
        }
        catch (Exception e) {
            LOG.error("Failed to restore PageStore", (Throwable)e);
        }
        if (!restored) {
            if (pageStore != null) {
                try {
                    pageStore.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close PageStore", (Throwable)e);
                }
            }
            metaStore.reset();
            evictor.reset();
            pageStore = PageStore.create(options, true);
        }
        return new LocalCacheManager(conf, metaStore, pageStore, evictor);
    }

    @VisibleForTesting
    LocalCacheManager(AlluxioConfiguration conf, MetaStore metaStore, PageStore pageStore, CacheEvictor evictor) {
        this.mMetaStore = metaStore;
        this.mPageStore = pageStore;
        this.mEvictor = evictor;
        this.mPageSize = conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE);
        this.mAsyncWrite = conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED);
        this.mCacheSize = pageStore.getCacheSize();
        for (int i = 0; i < 1024; ++i) {
            this.mPageLocks[i] = new ReentrantReadWriteLock(true);
        }
        this.mPendingRequests = new ConcurrentHashSet();
        this.mAsyncCacheExecutor = this.mAsyncWrite ? new ThreadPoolExecutor(conf.getInt(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_THREADS), conf.getInt(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_THREADS), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()) : null;
        Metrics.registerGauges(this.mCacheSize, this.mMetaStore);
    }

    private int getPageLockId(PageId pageId) {
        return Math.floorMod((int)((long)pageId.getFileId().hashCode() + pageId.getPageIndex()), 1024);
    }

    private ReadWriteLock getPageLock(PageId pageId) {
        return this.mPageLocks[this.getPageLockId(pageId)];
    }

    private Pair<ReadWriteLock, ReadWriteLock> getPageLockPair(PageId pageId1, PageId pageId2) {
        int lockId2;
        int lockId1 = this.getPageLockId(pageId1);
        if (lockId1 < (lockId2 = this.getPageLockId(pageId2))) {
            return new Pair<ReadWriteLock, ReadWriteLock>(this.mPageLocks[lockId1], this.mPageLocks[lockId2]);
        }
        return new Pair<ReadWriteLock, ReadWriteLock>(this.mPageLocks[lockId2], this.mPageLocks[lockId1]);
    }

    @Override
    public boolean put(PageId pageId, byte[] page) {
        LOG.debug("put({},{} bytes) enters", (Object)pageId, (Object)page.length);
        if (!this.mAsyncWrite) {
            boolean inserted = this.putInternal(pageId, page);
            LOG.debug("put({},{} bytes) exits: {}", new Object[]{pageId, page.length, inserted});
            return inserted;
        }
        if (!this.mPendingRequests.add(pageId)) {
            return false;
        }
        try {
            this.mAsyncCacheExecutor.submit(() -> {
                try {
                    this.putInternal(pageId, page);
                }
                finally {
                    this.mPendingRequests.remove(pageId);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.mPendingRequests.remove(pageId);
            Metrics.PUT_ERRORS.inc();
            LOG.debug("put({},{} bytes) fails due to full queue", (Object)pageId, (Object)page.length);
            return false;
        }
        LOG.debug("put({},{} bytes) exits with async write", (Object)pageId, (Object)page.length);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean putInternal(PageId pageId, byte[] page) {
        PageInfo victimPageInfo;
        block156: {
            LockResource r2;
            boolean enoughSpace;
            PageId victim;
            block153: {
                LOG.debug("putInternal({},{} bytes) enters", (Object)pageId, (Object)page.length);
                victim = null;
                victimPageInfo = null;
                ReadWriteLock pageLock = this.getPageLock(pageId);
                try (LockResource r = new LockResource(pageLock.writeLock());){
                    try (LockResource r22 = new LockResource(this.mMetaLock.writeLock());){
                        if (this.mMetaStore.hasPage(pageId)) {
                            LOG.debug("{} is already inserted before", (Object)pageId);
                            boolean bl = false;
                            return bl;
                        }
                        boolean bl = enoughSpace = this.mMetaStore.bytes() + (long)page.length <= this.mCacheSize;
                        if (enoughSpace) {
                            this.mMetaStore.addPage(pageId, new PageInfo(pageId, page.length));
                        } else {
                            victim = this.mEvictor.evict();
                        }
                    }
                    if (!enoughSpace) break block153;
                    boolean ret = this.addPage(pageId, page);
                    if (!ret) {
                        try {
                            r2 = new LockResource(this.mMetaLock.writeLock());
                            Throwable throwable = null;
                            try {
                                this.mMetaStore.removePage(pageId);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (r2 != null) {
                                    if (throwable != null) {
                                        try {
                                            r2.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        r2.close();
                                    }
                                }
                            }
                        }
                        catch (PageNotFoundException e) {
                            Metrics.PUT_FAILED_WRITE_ERRORS.inc();
                        }
                    }
                    LOG.debug("Add page ({},{} bytes) without eviction: {}", new Object[]{pageId, page.length, ret});
                    boolean e = ret;
                    return e;
                }
            }
            Pair<ReadWriteLock, ReadWriteLock> pageLockPair = this.getPageLockPair(pageId, victim);
            try (LockResource r1 = new LockResource(pageLockPair.getFirst().writeLock());){
                r2 = new LockResource(pageLockPair.getSecond().writeLock());
                Throwable throwable = null;
                try {
                    try (LockResource r3 = new LockResource(this.mMetaLock.writeLock());){
                        if (this.mMetaStore.hasPage(pageId)) {
                            LOG.debug("{} is already inserted by a racing thread", (Object)pageId);
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.mMetaStore.hasPage(victim)) {
                            LOG.debug("{} is already evicted by a racing thread", (Object)pageId);
                            boolean bl = false;
                            return bl;
                        }
                        try {
                            victimPageInfo = this.mMetaStore.getPageInfo(victim);
                            this.mMetaStore.removePage(victim);
                        }
                        catch (PageNotFoundException e) {
                            LOG.error("Page store is missing page {}: {}", (Object)victim, (Object)e);
                            boolean bl = false;
                            if (r3 != null) {
                                if (var13_34 != null) {
                                    try {
                                        r3.close();
                                    }
                                    catch (Throwable throwable4) {
                                        var13_34.addSuppressed(throwable4);
                                    }
                                } else {
                                    r3.close();
                                }
                            }
                            if (r2 != null) {
                                if (throwable != null) {
                                    try {
                                        r2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    r2.close();
                                }
                            }
                            if (r1 == null) return bl;
                            if (var9_8 == null) {
                                r1.close();
                                return bl;
                            }
                            try {
                                r1.close();
                                return bl;
                            }
                            catch (Throwable throwable6) {
                                var9_8.addSuppressed(throwable6);
                                return bl;
                            }
                        }
                        boolean bl = enoughSpace = this.mMetaStore.bytes() + (long)page.length <= this.mCacheSize;
                        if (enoughSpace) {
                            this.mMetaStore.addPage(pageId, new PageInfo(pageId, page.length));
                        }
                    }
                    if (!this.deletePage(victim, victimPageInfo)) {
                        LOG.debug("Failed to evict page: {}", (Object)victim);
                        boolean r3 = false;
                        return r3;
                    }
                    if (!enoughSpace) break block156;
                    boolean ret = this.addPage(pageId, page);
                    if (!ret) {
                        try (LockResource r3 = new LockResource(this.mMetaLock.writeLock());){
                            this.mMetaStore.removePage(pageId);
                        }
                        catch (PageNotFoundException e) {
                            Metrics.PUT_FAILED_WRITE_ERRORS.inc();
                        }
                    }
                    LOG.debug("Add page ({},{} bytes) after evicting ({}), success: {}", new Object[]{pageId, page.length, victimPageInfo, ret});
                    boolean bl = ret;
                    return bl;
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (r2 != null) {
                        if (throwable != null) {
                            try {
                                r2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            r2.close();
                        }
                    }
                }
            }
        }
        LOG.debug("putInternal({},{} bytes) fails after evicting ({})", new Object[]{pageId, page.length, victimPageInfo});
        return false;
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        Preconditions.checkArgument((long)pageOffset <= this.mPageSize, "Read exceeds page boundary: offset=%s size=%s", pageOffset, this.mPageSize);
        Preconditions.checkArgument(bytesToRead <= buffer.length - offsetInBuffer, "buffer does not have enough space: bufferLength=%s offsetInBuffer=%s bytesToRead=%s", (Object)buffer.length, (Object)offsetInBuffer, (Object)bytesToRead);
        LOG.debug("get({},pageOffset={}) enters", (Object)pageId, (Object)pageOffset);
        ReadWriteLock pageLock = this.getPageLock(pageId);
        try (LockResource r = new LockResource(pageLock.readLock());){
            boolean hasPage;
            try (LockResource r2 = new LockResource(this.mMetaLock.readLock());){
                hasPage = this.mMetaStore.hasPage(pageId);
            }
            if (!hasPage) {
                LOG.debug("get({},pageOffset={}) fails due to page not found", (Object)pageId, (Object)pageOffset);
                int r2 = 0;
                return r2;
            }
            int bytesRead = this.getPage(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer);
            if (bytesRead <= 0) {
                try (LockResource r2 = new LockResource(this.mMetaLock.writeLock());){
                    this.mMetaStore.removePage(pageId);
                }
                catch (PageNotFoundException e) {
                    Metrics.GET_ERRORS_FAILED_READ.inc();
                }
                int n = -1;
                return n;
            }
            LOG.debug("get({},pageOffset={}) exits", (Object)pageId, (Object)pageOffset);
            int n = bytesRead;
            return n;
        }
    }

    @Override
    public boolean delete(PageId pageId) {
        LOG.debug("delete({}) enters", (Object)pageId);
        ReadWriteLock pageLock = this.getPageLock(pageId);
        try (LockResource r = new LockResource(pageLock.writeLock());){
            PageInfo pageInfo;
            try (LockResource r1 = new LockResource(this.mMetaLock.writeLock());){
                try {
                    pageInfo = this.mMetaStore.getPageInfo(pageId);
                    this.mMetaStore.removePage(pageId);
                }
                catch (PageNotFoundException e) {
                    LOG.error("Failed to delete page {}: {}", (Object)pageId, (Object)e);
                    Metrics.DELETE_ERRORS.inc();
                    boolean bl = false;
                    if (r1 != null) {
                        if (var7_8 != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable) {
                                var7_8.addSuppressed(throwable);
                            }
                        } else {
                            r1.close();
                        }
                    }
                    if (r != null) {
                        if (var5_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var5_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                    return bl;
                }
            }
            boolean ret = this.deletePage(pageId, pageInfo);
            LOG.debug("delete({}) exits, success: {}", (Object)pageId, (Object)ret);
            boolean bl = ret;
            return bl;
        }
    }

    @Override
    public void close() throws Exception {
        this.mPageStore.close();
    }

    private boolean addPage(PageId pageId, byte[] page) {
        try {
            this.mPageStore.put(pageId, page);
        }
        catch (IOException e) {
            LOG.error("Failed to add page {}: {}", (Object)pageId, (Object)e);
            Metrics.PUT_ERRORS.inc();
            return false;
        }
        this.mEvictor.updateOnPut(pageId);
        Metrics.BYTES_WRITTEN_CACHE.mark(page.length);
        return true;
    }

    private boolean deletePage(PageId pageId, PageInfo pageInfo) {
        try {
            this.mPageStore.delete(pageId, pageInfo.getPageSize());
        }
        catch (PageNotFoundException | IOException e) {
            LOG.error("Failed to delete page {}: {}", (Object)pageId, (Object)e);
            Metrics.DELETE_ERRORS.inc();
            return false;
        }
        this.mEvictor.updateOnDelete(pageId);
        Metrics.BYTES_EVICTED_CACHE.mark(pageInfo.getPageSize());
        Metrics.PAGES_EVICTED_CACHE.mark();
        return true;
    }

    private int getPage(PageId pageId, int offset, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        try (ReadableByteChannel chan = this.mPageStore.get(pageId, offset);){
            ByteBuffer buf = ByteBuffer.wrap(buffer);
            buf.position(offsetInBuffer);
            buf.limit(offsetInBuffer + bytesToRead);
            while (buf.position() != buf.limit() && chan.read(buf) != -1) {
            }
            if (buf.position() != buf.limit()) {
                Metrics.GET_ERRORS_FAILED_READ.inc();
                throw new IOException(String.format("Failed to read page {}: supposed to read {} bytes, {} bytes actually read", pageId, bytesToRead, buf.position() - offsetInBuffer));
            }
        }
        catch (PageNotFoundException | IOException e) {
            LOG.error("Failed to get existing page {}: {}", (Object)pageId, (Object)e);
            Metrics.GET_ERRORS.inc();
            return -1;
        }
        this.mEvictor.updateOnGet(pageId);
        return bytesToRead;
    }

    private static final class Metrics {
        private static final Meter BYTES_WRITTEN_CACHE = MetricsSystem.meter(MetricKey.CLIENT_CACHE_BYTES_WRITTEN_CACHE.getName());
        private static final Meter BYTES_EVICTED_CACHE = MetricsSystem.meter(MetricKey.CLIENT_CACHE_BYTES_EVICTED.getName());
        private static final Meter PAGES_EVICTED_CACHE = MetricsSystem.meter(MetricKey.CLIENT_CACHE_PAGES_EVICTED.getName());
        private static final Counter DELETE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_DELETE_ERRORS.getName());
        private static final Counter GET_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_GET_ERRORS.getName());
        private static final Counter GET_ERRORS_FAILED_READ = MetricsSystem.counter(MetricKey.CLIENT_CACHE_GET_FAILED_READ_ERRORS.getName());
        private static final Counter PUT_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_ERRORS.getName());
        private static final Counter PUT_FAILED_WRITE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_FAILED_WRITE_ERRORS.getName());

        private Metrics() {
        }

        private static void registerGauges(long cacheSize, MetaStore metaStore) {
            MetricsSystem.registerGaugeIfAbsent(MetricsSystem.getMetricName(MetricKey.CLIENT_CACHE_SPACE_AVAILABLE.getName()), () -> cacheSize - metaStore.bytes());
            MetricsSystem.registerGaugeIfAbsent(MetricsSystem.getMetricName(MetricKey.CLIENT_CACHE_SPACE_USED.getName()), metaStore::bytes);
        }
    }
}

