/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcConnection;
import alluxio.grpc.GrpcConnectionPool;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServerAddress;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import alluxio.security.authentication.ChannelAuthenticator;
import javax.security.auth.Subject;

public final class GrpcChannelBuilder {
    private final GrpcChannelKey mChannelKey;
    private Subject mParentSubject;
    private boolean mAuthenticateChannel;
    private final AuthType mAuthType;
    private AlluxioConfiguration mConfiguration;

    private GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        this.mConfiguration = conf;
        this.mAuthType = this.mConfiguration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        this.mChannelKey = GrpcChannelKey.create(conf);
        this.mChannelKey.setServerAddress(address);
        this.mAuthenticateChannel = this.mAuthType != AuthType.NOSASL;
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        return new GrpcChannelBuilder(address, conf);
    }

    public GrpcChannelBuilder setClientType(String clientType) {
        this.mChannelKey.setClientType(clientType);
        return this;
    }

    public GrpcChannelBuilder setSubject(Subject subject) {
        this.mParentSubject = subject;
        return this;
    }

    public GrpcChannelBuilder disableAuthentication() {
        this.mAuthenticateChannel = false;
        return this;
    }

    public GrpcChannelBuilder setNetworkGroup(GrpcNetworkGroup group) {
        this.mChannelKey.setNetworkGroup(group);
        return this;
    }

    public GrpcChannel build() throws AlluxioStatusException {
        GrpcConnection connection = GrpcConnectionPool.INSTANCE.acquireConnection(this.mChannelKey, this.mConfiguration);
        try {
            AuthenticatedChannelClientDriver authDriver = null;
            if (this.mAuthenticateChannel) {
                ChannelAuthenticator channelAuthenticator = new ChannelAuthenticator(connection, this.mParentSubject, this.mAuthType, this.mConfiguration);
                channelAuthenticator.authenticate();
                authDriver = channelAuthenticator.getAuthenticationDriver();
            }
            return new GrpcChannel(connection, authDriver);
        }
        catch (Throwable t) {
            try {
                connection.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed release the connection.", e);
            }
            if (t instanceof UnavailableException) {
                throw new UnavailableException(String.format("Target Unavailable. %s", this.mChannelKey.toStringShort()), t.getCause());
            }
            throw AlluxioStatusException.fromThrowable(t);
        }
    }
}

