/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockResource
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LockResource.class);
    protected Lock mLock;
    private final Runnable mCloseAction;

    public LockResource(Lock lock) {
        this(lock, true, false);
    }

    public LockResource(Lock lock, boolean acquireLock, boolean useTryLock) {
        this(lock, acquireLock, useTryLock, null);
    }

    public LockResource(Lock lock, boolean acquireLock, boolean useTryLock, @Nullable Runnable closeAction) {
        this.mLock = lock;
        this.mCloseAction = closeAction;
        if (acquireLock) {
            this.mLock.lock();
        }
    }

    @VisibleForTesting
    public boolean hasSameLock(LockResource other) {
        return this.mLock == other.mLock;
    }

    @Override
    public void close() {
        if (this.mCloseAction != null) {
            this.mCloseAction.run();
        }
        this.mLock.unlock();
    }
}

