/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package alluxio.shaded.client.io.netty.handler.codec.sctp;

import alluxio.shaded.client.io.netty.channel.sctp.SctpMessage;
import alluxio.shaded.client.io.netty.handler.codec.CodecException;
import alluxio.shaded.client.io.netty.handler.codec.MessageToMessageDecoder;

public abstract class SctpMessageToMessageDecoder extends MessageToMessageDecoder<SctpMessage> {

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (msg instanceof SctpMessage) {
            SctpMessage sctpMsg = (SctpMessage) msg;
            if (sctpMsg.isComplete()) {
                return true;
            }

            throw new CodecException(String.format("Received SctpMessage is not alluxio.shaded.client.com.lete, please add %s in " +
                    "the pipeline before this handler", SctpMessageCompletionHandler.class.getSimpleName()));
        } else {
            return false;
        }
    }
}
