/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import alluxio.util.ThreadFactoryUtils;
import alluxio.util.executor.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ExecutorServiceFactories {
    public static ExecutorServiceFactory cachedThreadPool(String name) {
        return () -> Executors.newCachedThreadPool(ThreadFactoryUtils.build(name + "-%d", true));
    }

    public static ExecutorServiceFactory fixedThreadPool(String name, int nThreads) {
        return () -> Executors.newFixedThreadPool(nThreads, ThreadFactoryUtils.build(name + "-%d", true));
    }

    public static ExecutorServiceFactory constantExecutorServiceFactory(ExecutorService executorService) {
        return () -> executorService;
    }

    private ExecutorServiceFactories() {
    }
}

