/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.codahale.metrics.graphite;

import alluxio.shaded.client.com.codahale.metrics.Clock;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Gauge;
import alluxio.shaded.client.com.codahale.metrics.Histogram;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.com.codahale.metrics.Metered;
import alluxio.shaded.client.com.codahale.metrics.Metric;
import alluxio.shaded.client.com.codahale.metrics.MetricFilter;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.com.codahale.metrics.ScheduledReporter;
import alluxio.shaded.client.com.codahale.metrics.Snapshot;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.com.codahale.metrics.graphite.Graphite;
import alluxio.shaded.client.com.codahale.metrics.graphite.GraphiteSender;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporter.class);
    private final GraphiteSender graphite;
    private final Clock clock;
    private final String prefix;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private GraphiteReporter(MetricRegistry registry, GraphiteSender graphite, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "graphite-reporter", filter, rateUnit, durationUnit);
        this.graphite = graphite;
        this.clock = clock;
        this.prefix = prefix;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime() / 1000L;
        try {
            if (!this.graphite.isConnected()) {
                this.graphite.connect();
            }
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.graphite.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to Graphite", (Object)this.graphite, (Object)e);
            try {
                this.graphite.close();
            }
            catch (IOException iOException) {
                LOGGER.warn("Error closing Graphite", (Object)this.graphite, (Object)iOException);
            }
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from Graphite", (Object)this.graphite, (Object)e);
            }
        }
    }

    private void reportTimer(String name, Timer timer, long timestamp) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        this.graphite.send(this.prefix(name, "max"), this.format(this.convertDuration(snapshot.getMax())), timestamp);
        this.graphite.send(this.prefix(name, "mean"), this.format(this.convertDuration(snapshot.getMean())), timestamp);
        this.graphite.send(this.prefix(name, "min"), this.format(this.convertDuration(snapshot.getMin())), timestamp);
        this.graphite.send(this.prefix(name, "stddev"), this.format(this.convertDuration(snapshot.getStdDev())), timestamp);
        this.graphite.send(this.prefix(name, "p50"), this.format(this.convertDuration(snapshot.getMedian())), timestamp);
        this.graphite.send(this.prefix(name, "p75"), this.format(this.convertDuration(snapshot.get75thPercentile())), timestamp);
        this.graphite.send(this.prefix(name, "p95"), this.format(this.convertDuration(snapshot.get95thPercentile())), timestamp);
        this.graphite.send(this.prefix(name, "p98"), this.format(this.convertDuration(snapshot.get98thPercentile())), timestamp);
        this.graphite.send(this.prefix(name, "p99"), this.format(this.convertDuration(snapshot.get99thPercentile())), timestamp);
        this.graphite.send(this.prefix(name, "p999"), this.format(this.convertDuration(snapshot.get999thPercentile())), timestamp);
        this.reportMetered(name, timer, timestamp);
    }

    private void reportMetered(String name, Metered meter, long timestamp) throws IOException {
        this.graphite.send(this.prefix(name, "count"), this.format(meter.getCount()), timestamp);
        this.graphite.send(this.prefix(name, "m1_rate"), this.format(this.convertRate(meter.getOneMinuteRate())), timestamp);
        this.graphite.send(this.prefix(name, "m5_rate"), this.format(this.convertRate(meter.getFiveMinuteRate())), timestamp);
        this.graphite.send(this.prefix(name, "m15_rate"), this.format(this.convertRate(meter.getFifteenMinuteRate())), timestamp);
        this.graphite.send(this.prefix(name, "mean_rate"), this.format(this.convertRate(meter.getMeanRate())), timestamp);
    }

    private void reportHistogram(String name, Histogram histogram, long timestamp) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        this.graphite.send(this.prefix(name, "count"), this.format(histogram.getCount()), timestamp);
        this.graphite.send(this.prefix(name, "max"), this.format(snapshot.getMax()), timestamp);
        this.graphite.send(this.prefix(name, "mean"), this.format(snapshot.getMean()), timestamp);
        this.graphite.send(this.prefix(name, "min"), this.format(snapshot.getMin()), timestamp);
        this.graphite.send(this.prefix(name, "stddev"), this.format(snapshot.getStdDev()), timestamp);
        this.graphite.send(this.prefix(name, "p50"), this.format(snapshot.getMedian()), timestamp);
        this.graphite.send(this.prefix(name, "p75"), this.format(snapshot.get75thPercentile()), timestamp);
        this.graphite.send(this.prefix(name, "p95"), this.format(snapshot.get95thPercentile()), timestamp);
        this.graphite.send(this.prefix(name, "p98"), this.format(snapshot.get98thPercentile()), timestamp);
        this.graphite.send(this.prefix(name, "p99"), this.format(snapshot.get99thPercentile()), timestamp);
        this.graphite.send(this.prefix(name, "p999"), this.format(snapshot.get999thPercentile()), timestamp);
    }

    private void reportCounter(String name, Counter counter, long timestamp) throws IOException {
        this.graphite.send(this.prefix(name, "count"), this.format(counter.getCount()), timestamp);
    }

    private void reportGauge(String name, Gauge gauge, long timestamp) throws IOException {
        String value = this.format(gauge.getValue());
        if (value != null) {
            this.graphite.send(this.prefix(name), value, timestamp);
        }
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return null;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name(this.prefix, components);
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public GraphiteReporter build(Graphite graphite) {
            return this.build((GraphiteSender)graphite);
        }

        public GraphiteReporter build(GraphiteSender graphite) {
            return new GraphiteReporter(this.registry, graphite, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

