/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.io.BufferUtils;
import alluxio.worker.block.io.BlockWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LocalFileBlockWriter
implements BlockWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileBlockWriter.class);
    private final String mFilePath;
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private final Closer mCloser = Closer.create();
    private long mPosition;
    private boolean mClosed;

    public LocalFileBlockWriter(String path) throws IOException {
        this.mFilePath = Preconditions.checkNotNull(path, "path");
        this.mLocalFile = this.mCloser.register(new RandomAccessFile(this.mFilePath, "rw"));
        this.mLocalFileChannel = this.mCloser.register(this.mLocalFile.getChannel());
    }

    @Override
    public long append(ByteBuffer inputBuf) throws IOException {
        long bytesWritten = this.write(this.mLocalFileChannel.size(), inputBuf.duplicate());
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    @Override
    public long append(ByteBuf buf) throws IOException {
        long bytesWritten = buf.readBytes(this.mLocalFileChannel, buf.readableBytes());
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    @Override
    public long append(DataBuffer buffer) throws IOException {
        ByteBuf bytebuf = null;
        try {
            bytebuf = (ByteBuf)buffer.getNettyOutput();
        }
        catch (Throwable e) {
            LOG.debug("Failed to get ByteBuf from DataBuffer, write performance may be degraded.");
        }
        if (bytebuf != null) {
            return this.append(bytebuf);
        }
        long bytesWritten = this.write(this.mLocalFileChannel.size(), buffer);
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    @Override
    public long getPosition() {
        return this.mPosition;
    }

    @Override
    public WritableByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mCloser.close();
        this.mPosition = -1L;
    }

    private long write(long offset, ByteBuffer inputBuf) throws IOException {
        int inputBufLength = inputBuf.limit() - inputBuf.position();
        MappedByteBuffer outputBuf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, offset, inputBufLength);
        outputBuf.put(inputBuf);
        int bytesWritten = outputBuf.limit();
        BufferUtils.cleanDirectBuffer(outputBuf);
        return bytesWritten;
    }

    private long write(long offset, DataBuffer inputBuf) throws IOException {
        int inputBufLength = inputBuf.readableBytes();
        MappedByteBuffer outputBuf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, offset, inputBufLength);
        inputBuf.readBytes(outputBuf);
        int bytesWritten = outputBuf.limit();
        BufferUtils.cleanDirectBuffer(outputBuf);
        return bytesWritten;
    }
}

