/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.client.file.cache.store;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.MoreObjects;

/**
 * Options used to instantiate the {@link LocalPageStore}.
 */
public class LocalPageStoreOptions extends PageStoreOptions {

  /**
   * The number of file buckets. It is recommended to set this to a high value if the number of
   * unique files is expected to be high (# files / file buckets <= 100,000).
   */
  private int mFileBuckets;

  /**
   * Creates a new instance of {@link LocalPageStoreOptions}.
   */
  public LocalPageStoreOptions() {
    mFileBuckets = 1000;
  }

  /**
   * @param fileBuckets the number of buckets to place files in
   * @return the updated options
   */
  public LocalPageStoreOptions setFileBuckets(int fileBuckets) {
    mFileBuckets = fileBuckets;
    return this;
  }

  /**
   * @return the number of buckets to place files in
   */
  public int getFileBuckets() {
    return mFileBuckets;
  }

  @Override
  public PageStoreType getType() {
    return PageStoreType.LOCAL;
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this)
        .add("AlluxioVersion", mAlluxioVersion)
        .add("CacheSize", mCacheSize)
        .add("FileBuckets", mFileBuckets)
        .add("PageSize", mPageSize)
        .add("RootDir", mRootDir)
        .add("TimeoutDuration", mTimeoutDuration)
        .add("TimeoutThreads", mTimeoutThreads)
        .toString();
  }
}
