package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 **
 * This interface contains file system master service endpoints for Alluxio workers.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.28.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/file_system_master.proto")
public final class FileSystemMasterJobServiceGrpc {

  private FileSystemMasterJobServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.file.FileSystemMasterJobService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetFileInfoPRequest,
      alluxio.grpc.GetFileInfoPResponse> getGetFileInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFileInfo",
      requestType = alluxio.grpc.GetFileInfoPRequest.class,
      responseType = alluxio.grpc.GetFileInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetFileInfoPRequest,
      alluxio.grpc.GetFileInfoPResponse> getGetFileInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetFileInfoPRequest, alluxio.grpc.GetFileInfoPResponse> getGetFileInfoMethod;
    if ((getGetFileInfoMethod = FileSystemMasterJobServiceGrpc.getGetFileInfoMethod) == null) {
      synchronized (FileSystemMasterJobServiceGrpc.class) {
        if ((getGetFileInfoMethod = FileSystemMasterJobServiceGrpc.getGetFileInfoMethod) == null) {
          FileSystemMasterJobServiceGrpc.getGetFileInfoMethod = getGetFileInfoMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetFileInfoPRequest, alluxio.grpc.GetFileInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetFileInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetFileInfoPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetFileInfoPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new FileSystemMasterJobServiceMethodDescriptorSupplier("GetFileInfo"))
              .build();
        }
      }
    }
    return getGetFileInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUfsInfoPRequest,
      alluxio.grpc.GetUfsInfoPResponse> getGetUfsInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetUfsInfo",
      requestType = alluxio.grpc.GetUfsInfoPRequest.class,
      responseType = alluxio.grpc.GetUfsInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUfsInfoPRequest,
      alluxio.grpc.GetUfsInfoPResponse> getGetUfsInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUfsInfoPRequest, alluxio.grpc.GetUfsInfoPResponse> getGetUfsInfoMethod;
    if ((getGetUfsInfoMethod = FileSystemMasterJobServiceGrpc.getGetUfsInfoMethod) == null) {
      synchronized (FileSystemMasterJobServiceGrpc.class) {
        if ((getGetUfsInfoMethod = FileSystemMasterJobServiceGrpc.getGetUfsInfoMethod) == null) {
          FileSystemMasterJobServiceGrpc.getGetUfsInfoMethod = getGetUfsInfoMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetUfsInfoPRequest, alluxio.grpc.GetUfsInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetUfsInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetUfsInfoPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetUfsInfoPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new FileSystemMasterJobServiceMethodDescriptorSupplier("GetUfsInfo"))
              .build();
        }
      }
    }
    return getGetUfsInfoMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static FileSystemMasterJobServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<FileSystemMasterJobServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<FileSystemMasterJobServiceStub>() {
        @java.lang.Override
        public FileSystemMasterJobServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new FileSystemMasterJobServiceStub(channel, callOptions);
        }
      };
    return FileSystemMasterJobServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static FileSystemMasterJobServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<FileSystemMasterJobServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<FileSystemMasterJobServiceBlockingStub>() {
        @java.lang.Override
        public FileSystemMasterJobServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new FileSystemMasterJobServiceBlockingStub(channel, callOptions);
        }
      };
    return FileSystemMasterJobServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static FileSystemMasterJobServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<FileSystemMasterJobServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<FileSystemMasterJobServiceFutureStub>() {
        @java.lang.Override
        public FileSystemMasterJobServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new FileSystemMasterJobServiceFutureStub(channel, callOptions);
        }
      };
    return FileSystemMasterJobServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static abstract class FileSystemMasterJobServiceImplBase implements alluxio.shaded.client.io.grpc.BindableService {

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public void getFileInfo(alluxio.grpc.GetFileInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetFileInfoPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetFileInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public void getUfsInfo(alluxio.grpc.GetUfsInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUfsInfoPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetUfsInfoMethod(), responseObserver);
    }

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetFileInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetFileInfoPRequest,
                alluxio.grpc.GetFileInfoPResponse>(
                  this, METHODID_GET_FILE_INFO)))
          .addMethod(
            getGetUfsInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetUfsInfoPRequest,
                alluxio.grpc.GetUfsInfoPResponse>(
                  this, METHODID_GET_UFS_INFO)))
          .build();
    }
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static final class FileSystemMasterJobServiceStub extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<FileSystemMasterJobServiceStub> {
    private FileSystemMasterJobServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FileSystemMasterJobServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new FileSystemMasterJobServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public void getFileInfo(alluxio.grpc.GetFileInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetFileInfoPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetFileInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public void getUfsInfo(alluxio.grpc.GetUfsInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUfsInfoPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetUfsInfoMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static final class FileSystemMasterJobServiceBlockingStub extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<FileSystemMasterJobServiceBlockingStub> {
    private FileSystemMasterJobServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FileSystemMasterJobServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new FileSystemMasterJobServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public alluxio.grpc.GetFileInfoPResponse getFileInfo(alluxio.grpc.GetFileInfoPRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetFileInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public alluxio.grpc.GetUfsInfoPResponse getUfsInfo(alluxio.grpc.GetUfsInfoPRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetUfsInfoMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static final class FileSystemMasterJobServiceFutureStub extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<FileSystemMasterJobServiceFutureStub> {
    private FileSystemMasterJobServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FileSystemMasterJobServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new FileSystemMasterJobServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetFileInfoPResponse> getFileInfo(
        alluxio.grpc.GetFileInfoPRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetFileInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetUfsInfoPResponse> getUfsInfo(
        alluxio.grpc.GetUfsInfoPRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetUfsInfoMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_FILE_INFO = 0;
  private static final int METHODID_GET_UFS_INFO = 1;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final FileSystemMasterJobServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(FileSystemMasterJobServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_FILE_INFO:
          serviceImpl.getFileInfo((alluxio.grpc.GetFileInfoPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetFileInfoPResponse>) responseObserver);
          break;
        case METHODID_GET_UFS_INFO:
          serviceImpl.getUfsInfo((alluxio.grpc.GetUfsInfoPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUfsInfoPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class FileSystemMasterJobServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    FileSystemMasterJobServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.FileSystemMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("FileSystemMasterJobService");
    }
  }

  private static final class FileSystemMasterJobServiceFileDescriptorSupplier
      extends FileSystemMasterJobServiceBaseDescriptorSupplier {
    FileSystemMasterJobServiceFileDescriptorSupplier() {}
  }

  private static final class FileSystemMasterJobServiceMethodDescriptorSupplier
      extends FileSystemMasterJobServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    FileSystemMasterJobServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (FileSystemMasterJobServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new FileSystemMasterJobServiceFileDescriptorSupplier())
              .addMethod(getGetFileInfoMethod())
              .addMethod(getGetUfsInfoMethod())
              .build();
        }
      }
    }
    return result;
  }
}
