/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.annotations.GwtCompatible;
import java.alluxio.shaded.client.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

/** An ordering that tries several alluxio.shaded.client.com.arators in order. */
@GwtCompatible(serializable = true)
final class CompoundOrdering<T> extends Ordering<T> implements Serializable {
  final Comparator<? super T>[] alluxio.shaded.client.com.arators;

  CompoundOrdering(Comparator<? super T> primary, Comparator<? super T> secondary) {
    this.alluxio.shaded.client.com.arators = (Comparator<? super T>[]) new Comparator[] {primary, secondary};
  }

  CompoundOrdering(Iterable<? extends Comparator<? super T>> alluxio.shaded.client.com.arators) {
    this.alluxio.shaded.client.com.arators = Iterables.toArray(alluxio.shaded.client.com.arators, new Comparator[0]);
  }

  @Override
  public int alluxio.shaded.client.com.are(T left, T right) {
    for (int i = 0; i < alluxio.shaded.client.com.arators.length; i++) {
      int result = alluxio.shaded.client.com.arators[i].alluxio.shaded.client.com.are(left, right);
      if (result != 0) {
        return result;
      }
    }
    return 0;
  }

  @Override
  public boolean equals(Object object) {
    if (object == this) {
      return true;
    }
    if (object instanceof CompoundOrdering) {
      CompoundOrdering<?> that = (CompoundOrdering<?>) object;
      return Arrays.equals(this.alluxio.shaded.client.com.arators, that.alluxio.shaded.client.com.arators);
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Arrays.hashCode(alluxio.shaded.client.com.arators);
  }

  @Override
  public String toString() {
    return "Ordering.alluxio.shaded.client.com.ound(" + Arrays.toString(alluxio.shaded.client.com.arators) + ")";
  }

  private static final long serialVersionUID = 0;
}
