/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.AbstractMasterClient;
import alluxio.client.metrics.MetricsMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ClearMetricsPRequest;
import alluxio.grpc.ClientMetrics;
import alluxio.grpc.GetMetricsPOptions;
import alluxio.grpc.MetricValue;
import alluxio.grpc.MetricsHeartbeatPOptions;
import alluxio.grpc.MetricsHeartbeatPRequest;
import alluxio.grpc.MetricsMasterClientServiceGrpc;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetryHandlingMetricsMasterClient
extends AbstractMasterClient
implements MetricsMasterClient {
    private static final Logger LOG = LoggerFactory.getLogger(RetryHandlingMetricsMasterClient.class);
    private MetricsMasterClientServiceGrpc.MetricsMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingMetricsMasterClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.METRICS_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "MetricsMasterClient";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = MetricsMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public void clearMetrics() throws IOException {
        this.retryRPC(() -> this.mClient.clearMetrics(ClearMetricsPRequest.newBuilder().build()), LOG, "ClearMetrics", "", new Object[0]);
    }

    @Override
    public void heartbeat(List<ClientMetrics> metrics) throws IOException {
        this.connect();
        try {
            MetricsHeartbeatPRequest.Builder request = MetricsHeartbeatPRequest.newBuilder();
            request.setOptions(MetricsHeartbeatPOptions.newBuilder().addAllClientMetrics(metrics).build());
            this.mClient.metricsHeartbeat(request.build());
        }
        catch (StatusRuntimeException e) {
            this.disconnect();
            throw new UnavailableException(e);
        }
    }

    @Override
    public Map<String, MetricValue> getMetrics() throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getMetrics(GetMetricsPOptions.getDefaultInstance()).getMetricsMap(), LOG, "GetMetrics", "", new Object[0]);
    }
}

