/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.haproxy;

import alluxio.shaded.client.io.netty.handler.codec.DecoderException;

/**
 * A {@link DecoderException} which is thrown when an invalid HAProxy proxy protocol header is encountered
 */
public class HAProxyProtocolException extends DecoderException {

    private static final long serialVersionUID = 713710864325167351L;

    /**
     * Creates a new instance
     */
    public HAProxyProtocolException() { }

    /**
     * Creates a new instance
     */
    public HAProxyProtocolException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new instance
     */
    public HAProxyProtocolException(String message) {
        super(message);
    }

    /**
     * Creates a new instance
     */
    public HAProxyProtocolException(Throwable cause) {
        super(cause);
    }
}
