package alluxio.shaded.client.org.checkerframework.checker.initialization.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A declaration annotation for fields that indicates that a client might observe the field storing
 * values that are {@link alluxio.shaded.client.org.checkerframework.checker.initialization.qual.Initialized}, {@link
 * alluxio.shaded.client.org.checkerframework.checker.initialization.qual.UnderInitialization}, or {@link
 * alluxio.shaded.client.org.checkerframework.checker.initialization.qual.UnknownInitialization}, regardless of the
 * initialization type annotation on the field's type. This is necessary to allow circular
 * initialization as supported by freedom-before-alluxio.shaded.client.com.itment.
 *
 * @checker_framework.manual #initialization-checker Initialization Checker
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface NotOnlyInitialized {}
