package alluxio.shaded.client.org.checkerframework.checker.signature.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.QualifierForLiterals;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Represents a field descriptor (JVM type format) as defined in the <a
 * href="https://docs.oracle.alluxio.shaded.client.com.javase/specs/jvms/se11/html/jvms-4.html#jvms-4.3.2">Java Virtual
 * Machine Specification, section 4.3.2</a>.
 *
 * <p>For example, in
 *
 * <pre>
 *  package alluxio.shaded.client.org.checkerframework.checker.signature;
 *  public class SignatureChecker {
 *    private class Inner {}
 *  }
 * </pre>
 *
 * the field descriptors for the two types are
 * Lorg/checkerframework/checker/signature/SignatureChecker; and
 * Lorg/checkerframework/checker/signature/SignatureChecker$Inner; .
 *
 * @checker_framework.manual #signature-checker Signature Checker
 */
@SubtypeOf(SignatureUnknown.class)
@QualifierForLiterals(
        stringPatterns =
                "^\\[*([BCDFIJSZ]|L[A-Za-z_][A-Za-z_0-9]*(/[A-Za-z_][A-Za-z_0-9]*)*(\\$[A-Za-z_0-9]+)*;)$")
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface FieldDescriptor {}
