/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheEvictor;
import alluxio.client.file.cache.DefaultMetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.PageNotFoundException;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class QuotaMetaStore
extends DefaultMetaStore {
    private final Map<CacheScope, Long> mBytesInScope = new ConcurrentHashMap<CacheScope, Long>();
    private final Map<CacheScope, CacheEvictor> mCacheEvictors = new ConcurrentHashMap<CacheScope, CacheEvictor>();
    private final Supplier<CacheEvictor> mSupplier = () -> CacheEvictor.create(conf);

    public QuotaMetaStore(AlluxioConfiguration conf) {
        super(conf);
    }

    @Override
    public void addPage(PageId pageId, PageInfo pageInfo) {
        super.addPage(pageId, pageInfo);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            this.mBytesInScope.compute(cacheScope, (k, v) -> v == null ? pageInfo.getPageSize() : v + pageInfo.getPageSize());
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnPut(pageId);
        }
    }

    @Override
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        PageInfo pageInfo = super.getPageInfo(pageId);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnPut(pageId);
        }
        return pageInfo;
    }

    @Override
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        PageInfo pageInfo = super.removePage(pageId);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            this.mBytesInScope.computeIfPresent(cacheScope, (k, v) -> v - pageInfo.getPageSize());
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnDelete(pageId);
        }
        return pageInfo;
    }

    public long bytes(CacheScope cacheScope) {
        if (cacheScope == CacheScope.GLOBAL) {
            return this.bytes();
        }
        return this.mBytesInScope.computeIfAbsent(cacheScope, k -> 0L);
    }

    @Override
    public void reset() {
        super.reset();
        for (CacheEvictor evictor : this.mCacheEvictors.values()) {
            evictor.reset();
        }
        this.mBytesInScope.clear();
    }

    @Nullable
    public PageInfo evict(CacheScope cacheScope) {
        if (cacheScope == CacheScope.GLOBAL) {
            return this.evict();
        }
        CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
        return this.evictInternal(evictor);
    }
}

