/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.AbstractMasterClient;
import alluxio.AlluxioURI;
import alluxio.client.meta.MetaMasterConfigClient;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GetConfigHashPOptions;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.MetaMasterConfigurationServiceGrpc;
import alluxio.grpc.RemovePathConfigurationPRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.SetPathConfigurationPRequest;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.ConfigHash;
import alluxio.wire.Configuration;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetryHandlingMetaMasterConfigClient
extends AbstractMasterClient
implements MetaMasterConfigClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(MetaMasterConfigClient.class);
    private MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub mClient = null;

    public RetryHandlingMetaMasterConfigClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.META_MASTER_CONFIG_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "MetaMaster";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = MetaMasterConfigurationServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public Configuration getConfiguration(GetConfigurationPOptions options) throws IOException {
        return Configuration.fromProto(this.retryRPC(() -> ((MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub)this.mClient.withDeadlineAfter(this.mContext.getClusterConf().getMs(PropertyKey.WORKER_MASTER_PERIODICAL_RPC_TIMEOUT), TimeUnit.MILLISECONDS)).getConfiguration(options), RPC_LOG, "GetConfiguration", "options=%s", options));
    }

    @Override
    public ConfigHash getConfigHash() throws IOException {
        return ConfigHash.fromProto(this.retryRPC(() -> ((MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub)this.mClient.withDeadlineAfter(this.mContext.getClusterConf().getMs(PropertyKey.WORKER_MASTER_PERIODICAL_RPC_TIMEOUT), TimeUnit.MILLISECONDS)).getConfigHash(GetConfigHashPOptions.getDefaultInstance()), RPC_LOG, "GetConfigHash", "", new Object[0]));
    }

    @Override
    public void setPathConfiguration(AlluxioURI path, Map<PropertyKey, String> properties) throws IOException {
        HashMap props = new HashMap();
        properties.forEach((key, value) -> props.put(key.getName(), value));
        this.retryRPC(() -> this.mClient.setPathConfiguration(SetPathConfigurationPRequest.newBuilder().setPath(path.getPath()).putAllProperties(props).build()), RPC_LOG, "setPathConfiguration", "path=%s,properties=%s", path, properties);
    }

    @Override
    public void removePathConfiguration(AlluxioURI path, Set<PropertyKey> keys) throws IOException {
        HashSet<String> keySet = new HashSet<String>();
        for (PropertyKey key : keys) {
            keySet.add(key.getName());
        }
        this.retryRPC(() -> this.mClient.removePathConfiguration(RemovePathConfigurationPRequest.newBuilder().setPath(path.getPath()).addAllKeys(keySet).build()), RPC_LOG, "removePathConfiguration", "path=%s,keys=%s", path, keys);
    }

    @Override
    public void removePathConfiguration(AlluxioURI path) throws IOException {
        this.retryRPC(() -> this.mClient.removePathConfiguration(RemovePathConfigurationPRequest.newBuilder().setPath(path.getPath()).build()), RPC_LOG, "removePathConfiguration", "path=%s", path);
    }
}

