/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.CountingRetry;
import alluxio.retry.ExponentialTimeBoundedRetry;
import alluxio.retry.RetryPolicy;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtils.class);

    public static void retry(String action, RunnableThrowsIOException f, RetryPolicy policy) throws IOException {
        IOException e = null;
        while (policy.attempt()) {
            try {
                f.run();
                return;
            }
            catch (IOException ioe) {
                e = ioe;
                LOG.warn("Failed to {} (attempt {}): {}", new Object[]{action, policy.getAttemptCount(), e.toString()});
            }
        }
        throw e;
    }

    public static RetryPolicy noRetryPolicy() {
        return new CountingRetry(0);
    }

    public static RetryPolicy defaultClientRetry(Duration maxRetryDuration, Duration baseSleepMs, Duration maxSleepMs) {
        return ExponentialTimeBoundedRetry.builder().withMaxDuration(maxRetryDuration).withInitialSleep(baseSleepMs).withMaxSleep(maxSleepMs).build();
    }

    public static RetryPolicy defaultWorkerMasterClientRetry(Duration workerMasterConnectRetryTimeout) {
        return ExponentialTimeBoundedRetry.builder().withMaxDuration(workerMasterConnectRetryTimeout).withInitialSleep(Duration.ofMillis(100L)).withMaxSleep(Duration.ofSeconds(5L)).build();
    }

    public static RetryPolicy defaultMetricsClientRetry() {
        return new CountingRetry(0);
    }

    public static RetryPolicy defaultActiveSyncClientRetry(long activeUfsPollTimeoutMs) {
        return ExponentialTimeBoundedRetry.builder().withMaxDuration(Duration.ofMillis(activeUfsPollTimeoutMs)).withInitialSleep(Duration.ofMillis(100L)).withMaxSleep(Duration.ofSeconds(60L)).build();
    }

    public static RetryPolicy defaultBlockReadRetry(Duration maxRetryDuration, Duration baseSleepMs, Duration maxSleepMs) {
        return ExponentialTimeBoundedRetry.builder().withMaxDuration(maxRetryDuration).withInitialSleep(baseSleepMs).withMaxSleep(maxSleepMs).withSkipInitialSleep().build();
    }

    private RetryUtils() {
    }

    @FunctionalInterface
    public static interface RunnableThrowsIOException {
        public void run() throws IOException;
    }
}

