/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.server.auth;

import alluxio.shaded.client.org.apache.zookeeper.KeeperException;
import alluxio.shaded.client.org.apache.zookeeper.data.Id;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxn;
import alluxio.shaded.client.org.apache.zookeeper.server.auth.AuthenticationProvider;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DigestAuthenticationProvider.class);
    private static final String superDigest = System.getProperty("zookeeper.DigestAuthenticationProvider.superDigest");

    @Override
    public String getScheme() {
        return "digest";
    }

    private static final String base64Encode(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            int pad = 0;
            int v = (b[i++] & 0xFF) << 16;
            if (i < b.length) {
                v |= (b[i++] & 0xFF) << 8;
            } else {
                ++pad;
            }
            if (i < b.length) {
                v |= b[i++] & 0xFF;
            } else {
                ++pad;
            }
            sb.append(DigestAuthenticationProvider.encode(v >> 18));
            sb.append(DigestAuthenticationProvider.encode(v >> 12));
            if (pad < 2) {
                sb.append(DigestAuthenticationProvider.encode(v >> 6));
            } else {
                sb.append('=');
            }
            if (pad < 1) {
                sb.append(DigestAuthenticationProvider.encode(v));
                continue;
            }
            sb.append('=');
        }
        return sb.toString();
    }

    private static final char encode(int i) {
        if ((i &= 0x3F) < 26) {
            return (char)(65 + i);
        }
        if (i < 52) {
            return (char)(97 + i - 26);
        }
        if (i < 62) {
            return (char)(48 + i - 52);
        }
        return i == 62 ? (char)'+' : '/';
    }

    public static String generateDigest(String idPassword) throws NoSuchAlgorithmException {
        String[] parts = idPassword.split(":", 2);
        byte[] digest = MessageDigest.getInstance("SHA1").digest(idPassword.getBytes());
        return parts[0] + ":" + DigestAuthenticationProvider.base64Encode(digest);
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        String id = new String(authData);
        try {
            String digest = DigestAuthenticationProvider.generateDigest(id);
            if (digest.equals(superDigest)) {
                cnxn.addAuthInfo(new Id("super", ""));
            }
            cnxn.addAuthInfo(new Id(this.getScheme(), digest));
            return KeeperException.Code.OK;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Missing algorithm", (Throwable)e);
            return KeeperException.Code.AUTHFAILED;
        }
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        String[] parts = id.split(":");
        return parts.length == 2;
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        return id.equals(aclExpr);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i] + "->" + DigestAuthenticationProvider.generateDigest(args[i]));
        }
    }
}

