package alluxio.shaded.client.org.checkerframework.checker.nullness.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultFor;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultInUncheckedCodeFor;
import alluxio.shaded.client.org.checkerframework.framework.qual.LiteralKind;
import alluxio.shaded.client.org.checkerframework.framework.qual.QualifierForLiterals;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;
import alluxio.shaded.client.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * {@link Nullable} is a type annotation that indicates that the value is not known to be non-null
 * (see {@link NonNull}). Only if an expression has a {@link Nullable} type may it be assigned
 * {@code null}.
 *
 * <p>This annotation is associated with the {@link
 * alluxio.shaded.client.org.checkerframework.checker.nullness.NullnessChecker}.
 *
 * @see NonNull
 * @see MonotonicNonNull
 * @see alluxio.shaded.client.org.checkerframework.checker.nullness.NullnessChecker
 * @checker_framework.manual #nullness-checker Nullness Checker
 */
@SubtypeOf({})
@QualifierForLiterals(LiteralKind.NULL)
@DefaultFor(types = Void.class)
@DefaultInUncheckedCodeFor({TypeUseLocation.RETURN, TypeUseLocation.UPPER_BOUND})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface Nullable {}
