/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.wire;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.MoreObjects;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.tuple.Triple;

import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.alluxio.shaded.client.io.Serializable;
import java.util.List;
import java.util.TreeSet;

/**
 * Alluxio WebUI configuration information.
 */
@NotThreadSafe
public final class WorkerWebUIConfiguration implements Serializable {
  private static final long serialVersionUID = -2277858633604882055L;

  private List<String> mWhitelist;
  private TreeSet<Triple<String, String, String>> mConfiguration;

  /**
   * Creates a new instance of {@link WorkerWebUIConfiguration}.
   */
  public WorkerWebUIConfiguration() {
  }

  /**
   * Gets configuration.
   *
   * @return the configuration
   */
  public TreeSet<Triple<String, String, String>> getConfiguration() {
    return mConfiguration;
  }

  /**
   * Gets whitelist.
   *
   * @return the whitelist
   */
  public List<String> getWhitelist() {
    return mWhitelist;
  }

  /**
   * Sets configuration.
   *
   * @param configuration the configuration
   * @return the configuration
   */
  public WorkerWebUIConfiguration setConfiguration(
      TreeSet<Triple<String, String, String>> configuration) {
    mConfiguration = configuration;
    return this;
  }

  /**
   * Sets whitelist.
   *
   * @param whitelist the whitelist
   * @return the whitelist
   */
  public WorkerWebUIConfiguration setWhitelist(List<String> whitelist) {
    mWhitelist = whitelist;
    return this;
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this).add("configuration", mConfiguration)
        .add("whitelist", mWhitelist).toString();
  }
}
