/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SessionInfo {
    private final long mSessionId;
    private long mLastHeartbeatMs;
    private final int mSessionTimeoutMs;

    public SessionInfo(long sessionId, int sessionTimeoutMs) {
        Preconditions.checkArgument(sessionId > 0L, "Invalid session id " + sessionId);
        Preconditions.checkArgument(sessionTimeoutMs > 0, "Invalid session timeout");
        this.mSessionId = sessionId;
        this.mLastHeartbeatMs = System.currentTimeMillis();
        this.mSessionTimeoutMs = sessionTimeoutMs;
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public synchronized void heartbeat() {
        this.mLastHeartbeatMs = System.currentTimeMillis();
    }

    public synchronized boolean timeout() {
        return System.currentTimeMillis() - this.mLastHeartbeatMs > (long)this.mSessionTimeoutMs;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper(this).add("sessionId", this.mSessionId).add("lastHeartbeatMs", this.mLastHeartbeatMs).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionInfo)) {
            return false;
        }
        SessionInfo that = (SessionInfo)o;
        return this.mSessionId == that.mSessionId;
    }

    public int hashCode() {
        return (int)(this.mSessionId ^ this.mSessionId >>> 32);
    }
}

