/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.sink.Sink;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.com.codahale.metrics.jmx.JmxReporter;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Properties;

@ThreadSafe
public final class JmxSink
implements Sink {
    private static final String DOMAIN = "alluxio.shaded.client.org.alluxio";
    private JmxReporter mReporter;

    public JmxSink(Properties properties, MetricRegistry registry) {
        JmxReporter.Builder builder = JmxReporter.forRegistry(registry);
        String domain = properties.getProperty("domain");
        if (domain != null) {
            builder.inDomain(domain);
        } else {
            builder.inDomain(DOMAIN);
        }
        this.mReporter = builder.build();
    }

    @Override
    public void start() {
        this.mReporter.start();
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
    }
}

