/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.org.apache.commons.io.IOUtils;
import alluxio.shaded.client.org.apache.http.Header;
import alluxio.shaded.client.org.apache.http.client.config.RequestConfig;
import alluxio.shaded.client.org.apache.http.client.methods.CloseableHttpResponse;
import alluxio.shaded.client.org.apache.http.client.methods.HttpUriRequest;
import alluxio.shaded.client.org.apache.http.client.methods.RequestBuilder;
import alluxio.shaded.client.org.apache.http.impl.client.CloseableHttpClient;
import alluxio.shaded.client.org.apache.http.impl.client.HttpClientBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static void post(String url, String cookies, Integer timeout, IProcessInputStream processInputStream) throws IOException {
        block8: {
            Preconditions.checkNotNull(timeout, "timeout");
            Preconditions.checkNotNull(processInputStream, "processInputStream");
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();){
                HttpUriRequest req = cookies.isEmpty() ? RequestBuilder.post(url).build() : RequestBuilder.post(url).setHeader("Cookie", cookies).build();
                CloseableHttpResponse response = client.execute(req);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 201) {
                    InputStream inputStream = response.getEntity().getContent();
                    processInputStream.process(inputStream);
                    break block8;
                }
                if (LOG.isDebugEnabled()) {
                    String content = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.ISO_8859_1);
                    LOG.debug("Full content: {}", (Object)content);
                }
                throw new IOException(String.format("Failed to perform POST request: %s", response.getStatusLine()));
            }
        }
    }

    public static String post(String url, Integer timeout) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        HttpUtils.post(url, "", timeout, inputStream -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    contentBuffer.append(line);
                }
            }
        });
        return contentBuffer.toString();
    }

    public static InputStream getInputStream(String url, Integer timeout) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        final CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        CloseableHttpResponse response = client.execute(RequestBuilder.get(url).build());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 201) {
            throw new IOException("Failed to perform GET request. Status code: " + statusCode);
        }
        InputStream inputStream = response.getEntity().getContent();
        return new BufferedInputStream(inputStream){

            @Override
            public void close() throws IOException {
                client.close();
            }
        };
    }

    public static void get(String url, Integer timeout, IProcessInputStream processInputStream) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        Preconditions.checkNotNull(processInputStream, "processInputStream");
        try (InputStream inputStream = HttpUtils.getInputStream(url, timeout);){
            processInputStream.process(inputStream);
        }
    }

    public static String get(String url, Integer timeout) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        StringBuilder contentBuffer = new StringBuilder();
        HttpUtils.get(url, timeout, inputStream -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    contentBuffer.append(line);
                }
            }
        });
        return contentBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Header[] head(String url, Integer timeout) {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();){
            CloseableHttpResponse response = client.execute(RequestBuilder.head(url).build());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 201) {
                Header[] headerArray = response.getAllHeaders();
                return headerArray;
            }
            LOG.error("Failed to perform HEAD request. Status code: {}", (Object)statusCode);
            return null;
        }
        catch (Exception e) {
            LOG.error("Failed to execute URL request: {}", (Object)url, (Object)e);
        }
        return null;
    }

    public static interface IProcessInputStream {
        public void process(InputStream var1) throws IOException;
    }
}

