/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.proto.client.Cache;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import java.util.ArrayList;
import org.rocksdb.CompressionType;

public class RocksPageStoreOptions
extends PageStoreOptions {
    private static final double ROCKS_OVERHEAD_RATIO = 0.2;
    private int mMaxPageSize;
    private int mWriteBufferSize;
    private int mMaxBufferPoolSize;
    private CompressionType mCompressionType;

    public RocksPageStoreOptions() {
        this.mRootDirs = new ArrayList();
        this.mMaxPageSize = 0x100000;
        this.mWriteBufferSize = 0x4000000;
        this.mMaxBufferPoolSize = 32;
        this.mCompressionType = CompressionType.NO_COMPRESSION;
        this.mOverheadRatio = 0.2;
    }

    public RocksPageStoreOptions setMaxPageSize(int maxPageSize) {
        this.mMaxPageSize = maxPageSize;
        return this;
    }

    public int getMaxPageSize() {
        return this.mMaxPageSize;
    }

    public RocksPageStoreOptions setWriteBufferSize(int writeBufferSize) {
        this.mWriteBufferSize = writeBufferSize;
        return this;
    }

    public int getWriteBufferSize() {
        return this.mWriteBufferSize;
    }

    public RocksPageStoreOptions setMaxBufferPoolSize(int bufferPoolSize) {
        this.mMaxBufferPoolSize = bufferPoolSize;
        return this;
    }

    public int getMaxBufferPoolSize() {
        return this.mMaxBufferPoolSize;
    }

    public RocksPageStoreOptions setCompressionType(CompressionType type) {
        this.mCompressionType = type;
        return this;
    }

    public CompressionType getCompressionType() {
        return this.mCompressionType;
    }

    @Override
    public PageStoreType getType() {
        return PageStoreType.ROCKS;
    }

    public Cache.PRocksPageStoreOptions toProto() {
        return Cache.PRocksPageStoreOptions.newBuilder().setCommonOptions(Cache.PPageStoreCommonOptions.newBuilder().setPageSize(this.getPageSize()).setCacheSize(this.getCacheSize()).setAlluxioVersion(this.getAlluxioVersion())).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("AlluxioVersion", this.mAlluxioVersion).add("CacheSize", this.mCacheSize).add("CompressionType", (Object)this.mCompressionType).add("MaxBufferPoolSize", this.mMaxBufferPoolSize).add("MaxPageSize", this.mMaxPageSize).add("OverheadRatio", this.mOverheadRatio).add("PageSize", this.mPageSize).add("RootDirs", this.mRootDirs).add("TimeoutDuration", this.mTimeoutDuration).add("TimeoutThreads", this.mTimeoutThreads).add("WriteBufferSize", this.mWriteBufferSize).toString();
    }
}

