/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerNetAddress;

@ThreadSafe
public final class SpecificHostPolicy
implements BlockLocationPolicy {
    private final String mHostname;

    public SpecificHostPolicy(AlluxioConfiguration conf) {
        this(conf.getString(PropertyKey.WORKER_HOSTNAME));
    }

    public SpecificHostPolicy(String hostname) {
        this.mHostname = Preconditions.checkNotNull(hostname, "hostname");
    }

    @Override
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        for (BlockWorkerInfo info : options.getBlockWorkerInfos()) {
            if (!info.getNetAddress().getHost().equals(this.mHostname)) continue;
            return info.getNetAddress();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecificHostPolicy)) {
            return false;
        }
        SpecificHostPolicy that = (SpecificHostPolicy)o;
        return Objects.equal(this.mHostname, that.mHostname);
    }

    public int hashCode() {
        return Objects.hashCode(this.mHostname);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hostname", this.mHostname).toString();
    }
}

