/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import java.util.concurrent.locks.StampedLock;

public class SegmentedLock {
    private final int mNumLocks;
    private final int mBitsOfLock;
    private final int mMaskBits;
    private final StampedLock[] mLocks;
    private final int mNumBucketsPerSegment;

    public SegmentedLock(int numLocks, int numBuckets) {
        int highestBit = Integer.highestOneBit(numLocks);
        if (highestBit < numLocks) {
            numLocks = highestBit << 1;
        }
        this.mNumLocks = numLocks;
        this.mBitsOfLock = Integer.numberOfTrailingZeros(numLocks);
        this.mNumBucketsPerSegment = numBuckets / numLocks;
        int bitsOfBuckets = Integer.numberOfTrailingZeros(Integer.highestOneBit(numBuckets));
        this.mMaskBits = bitsOfBuckets - this.mBitsOfLock;
        this.mLocks = new StampedLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.mLocks[i] = new StampedLock();
        }
    }

    public void readLock(int b) {
        int i = this.getSegmentIndex(b);
        this.mLocks[i].readLock();
    }

    public void readLock(int b1, int b2) {
        int i2;
        int i1 = this.getSegmentIndex(b1);
        if (i1 > (i2 = this.getSegmentIndex(b2))) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        this.mLocks[i1].readLock();
        if (i2 != i1) {
            this.mLocks[i2].readLock();
        }
    }

    public void unlockRead(int b) {
        int i = this.getSegmentIndex(b);
        this.mLocks[i].tryUnlockRead();
    }

    public void unlockRead(int b1, int b2) {
        int i2;
        int i1 = this.getSegmentIndex(b1);
        if (i1 > (i2 = this.getSegmentIndex(b2))) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        this.mLocks[i2].tryUnlockRead();
        if (i1 != i2) {
            this.mLocks[i1].tryUnlockRead();
        }
    }

    public void writeLock(int b) {
        int i = this.getSegmentIndex(b);
        this.mLocks[i].writeLock();
    }

    public void writeLock(int b1, int b2) {
        int i2;
        int i1 = this.getSegmentIndex(b1);
        if (i1 > (i2 = this.getSegmentIndex(b2))) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        this.mLocks[i1].writeLock();
        if (i2 != i1) {
            this.mLocks[i2].writeLock();
        }
    }

    public void writeLock(int b1, int b2, int b3) {
        int tmp;
        int i1 = this.getSegmentIndex(b1);
        int i2 = this.getSegmentIndex(b2);
        int i3 = this.getSegmentIndex(b3);
        if (i1 > i2) {
            tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        if (i2 > i3) {
            tmp = i2;
            i2 = i3;
            i3 = tmp;
        }
        if (i1 > i2) {
            tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        this.mLocks[i1].writeLock();
        if (i2 != i1) {
            this.mLocks[i2].writeLock();
        }
        if (i3 != i2) {
            this.mLocks[i3].writeLock();
        }
    }

    public void unlockWrite(int b) {
        int i = this.getSegmentIndex(b);
        this.mLocks[i].tryUnlockWrite();
    }

    public void unlockWrite(int b1, int b2) {
        int i2;
        int i1 = this.getSegmentIndex(b1);
        if (i1 > (i2 = this.getSegmentIndex(b2))) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        this.mLocks[i2].tryUnlockWrite();
        if (i1 != i2) {
            this.mLocks[i1].tryUnlockWrite();
        }
    }

    public void unlockWrite(int b1, int b2, int b3) {
        int tmp;
        int i1 = this.getSegmentIndex(b1);
        int i2 = this.getSegmentIndex(b2);
        int i3 = this.getSegmentIndex(b3);
        if (i1 > i2) {
            tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        if (i2 > i3) {
            tmp = i2;
            i2 = i3;
            i3 = tmp;
        }
        if (i1 > i2) {
            tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        this.mLocks[i3].tryUnlockWrite();
        if (i2 != i3) {
            this.mLocks[i2].tryUnlockWrite();
        }
        if (i1 != i2) {
            this.mLocks[i1].tryUnlockWrite();
        }
    }

    public void writeLockSegment(int i) {
        this.mLocks[i].writeLock();
    }

    public void unlockWriteSegment(int i) {
        this.mLocks[i].tryUnlockWrite();
    }

    public int getNumLocks() {
        return this.mNumLocks;
    }

    public int getNumBucketsPerSegment() {
        return this.mNumBucketsPerSegment;
    }

    public int getSegmentStartPos(int i) {
        return i << this.mMaskBits;
    }

    public int getSegmentIndex(int b) {
        return b >> this.mMaskBits;
    }
}

