/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageTier;
import alluxio.worker.block.meta.TempBlockMeta;
import java.util.List;
import java.util.Optional;

public interface StorageDir {
    public long getCapacityBytes();

    public long getAvailableBytes();

    public long getCommittedBytes();

    public String getDirPath();

    public String getDirMedium();

    public StorageTier getParentTier();

    public int getDirIndex();

    public List<Long> getBlockIds();

    public List<BlockMeta> getBlocks();

    public boolean hasBlockMeta(long var1);

    public boolean hasTempBlockMeta(long var1);

    public Optional<BlockMeta> getBlockMeta(long var1);

    public TempBlockMeta getTempBlockMeta(long var1);

    public void addBlockMeta(BlockMeta var1) throws WorkerOutOfSpaceException, BlockAlreadyExistsException;

    public void addTempBlockMeta(TempBlockMeta var1) throws WorkerOutOfSpaceException, BlockAlreadyExistsException;

    public void removeBlockMeta(BlockMeta var1);

    public void removeTempBlockMeta(TempBlockMeta var1) throws BlockDoesNotExistException;

    public void resizeTempBlockMeta(TempBlockMeta var1, long var2) throws InvalidWorkerStateException;

    public void cleanupSessionTempBlocks(long var1, List<Long> var3);

    public List<TempBlockMeta> getSessionTempBlocks(long var1);

    public BlockStoreLocation toBlockStoreLocation();

    public long getReservedBytes();
}

