/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains generic collection interfaces and implementations, and other utilities for
 * working with collections. It is a part of the open-source <a
 * href="http://github.alluxio.shaded.client.com.google/guava">Guava</a> library.
 *
 * <h2>Collection Types</h2>
 *
 * <dl>
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.BiMap}
 *   <dd>An extension of {@link java.util.Map} that guarantees the uniqueness of its values as well
 *       as that of its keys. This is sometimes called an "invertible map," since the restriction on
 *       values enables it to support an {@linkplain alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.BiMap#inverse inverse
 *       view} -- which is another instance of {@code BiMap}.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multiset}
 *   <dd>An extension of {@link java.util.Collection} that may contain duplicate values like a
 *       {@link java.util.List}, yet has order-independent equality like a {@link java.util.Set}.
 *       One typical use for a multiset is to represent a histogram.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimap}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but may contain multiple entries
 *       with the same key. Some behaviors of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimap} are left
 *       unspecified and are provided only by the subtypes mentioned below.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ListMultimap}
 *   <dd>An extension of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimap} which permits duplicate entries,
 *       supports random access of values for a particular key, and has <i>partially order-dependent
 *       equality</i> as defined by {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ListMultimap#equals(Object)}.
 *       {@code ListMultimap} takes its name from the fact that the {@linkplain
 *       alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ListMultimap#get collection of values} associated with a given
 *       key fulfills the {@link java.util.List} contract.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.SetMultimap}
 *   <dd>An extension of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimap} which has order-independent
 *       equality and does not allow duplicate entries; that is, while a key may appear twice in a
 *       {@code SetMultimap}, each must map to a different value. {@code SetMultimap} takes its name
 *       from the fact that the {@linkplain alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.SetMultimap#get collection of
 *       values} associated with a given key fulfills the {@link java.util.Set} contract.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.SortedSetMultimap}
 *   <dd>An extension of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.SetMultimap} for which the {@linkplain
 *       alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.SortedSetMultimap#get collection values} associated with a given
 *       key is a {@link java.util.SortedSet}.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Table}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but which indexes its values by an
 *       ordered pair of keys, a row key and column key.
 *   <dt>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ClassToInstanceMap}
 *   <dd>An extension of {@link java.util.Map} that associates a raw type with an instance of that
 *       type.
 * </dl>
 *
 * <h2>Collection Implementations</h2>
 *
 * <h3>of {@link java.util.List}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableList}
 * </ul>
 *
 * <h3>of {@link java.util.Set}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableSet}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableSortedSet}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ContiguousSet} (see {@code Range})
 * </ul>
 *
 * <h3>of {@link java.util.Map}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableSortedMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.MapMaker}
 * </ul>
 *
 * <h3>of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.BiMap}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableBiMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.HashBiMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.EnumBiMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.EnumHashBiMap}
 * </ul>
 *
 * <h3>of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multiset}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableSortedMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.HashMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.LinkedHashMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.TreeMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.EnumMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ConcurrentHashMultiset}
 * </ul>
 *
 * <h3>of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimap}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableListMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableSetMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ArrayListMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.HashMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.TreeMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.LinkedHashMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.LinkedListMultimap}
 * </ul>
 *
 * <h3>of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Table}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableTable}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ArrayTable}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.HashBasedTable}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.TreeBasedTable}
 * </ul>
 *
 * <h3>of {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ClassToInstanceMap}</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableClassToInstanceMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.MutableClassToInstanceMap}
 * </ul>
 *
 * <h2>Classes of static utility methods</h2>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Collections2}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Iterators}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Iterables}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Lists}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Maps}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Queues}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Sets}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multisets}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimaps}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Tables}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ObjectArrays}
 * </ul>
 *
 * <h2>Comparison</h2>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Ordering}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ComparisonChain}
 * </ul>
 *
 * <h2>Abstract implementations</h2>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.AbstractIterator}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.AbstractSequentialIterator}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableCollection}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.UnmodifiableIterator}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.UnmodifiableListIterator}
 * </ul>
 *
 * <h2>Ranges</h2>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Range}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.RangeMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.DiscreteDomain}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ContiguousSet}
 * </ul>
 *
 * <h2>Other</h2>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Interner}, {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Interners}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.MapDifference}, {@link
 *       alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.SortedMapDifference}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.MinMaxPriorityQueue}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.PeekingIterator}
 * </ul>
 *
 * <h2>Forwarding collections</h2>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingCollection}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingConcurrentMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingIterator}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingList}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingListIterator}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingListMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingMapEntry}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingNavigableMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingNavigableSet}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingObject}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingQueue}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingSet}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingSetMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingSortedMap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingSortedMultiset}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingSortedSet}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingSortedSetMultimap}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ForwardingTable}
 * </ul>
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect;

import alluxio.shaded.client.com.google.errorprone.annotations.CheckReturnValue;
import alluxio.shaded.client.javax.annotation.ParametersAreNonnullByDefault;
