/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractClient;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcServerAddress;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.retry.RetryPolicy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.function.Supplier;

@ThreadSafe
public abstract class AbstractMasterClient
extends AbstractClient {
    private final MasterInquireClient mMasterInquireClient;

    public AbstractMasterClient(MasterClientContext clientConf) {
        super(clientConf);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
    }

    public AbstractMasterClient(MasterClientContext clientConf, Supplier<RetryPolicy> retryPolicySupplier) {
        super(clientConf, retryPolicySupplier);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
    }

    @Override
    protected synchronized GrpcServerAddress queryGrpcServerAddress() throws UnavailableException {
        return GrpcServerAddress.create(this.mMasterInquireClient.getPrimaryRpcAddress());
    }
}

