/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageStore;
import alluxio.exception.PageNotFoundException;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MemoryPageStore
implements PageStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryPageStore.class);
    private ConcurrentHashMap<PageId, byte[]> mPageStoreMap = new ConcurrentHashMap();

    @Override
    public void put(PageId pageId, byte[] page, boolean isTemporary) throws IOException {
        PageId pageKey = this.getKeyFromPageId(pageId);
        try {
            byte[] pageCopy = new byte[page.length];
            System.arraycopy(page, 0, pageCopy, 0, page.length);
            this.mPageStoreMap.put(pageKey, pageCopy);
        }
        catch (Exception e) {
            throw new IOException("Failed to put cached data in memory for page " + pageId);
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int bufferOffset, boolean isTemporary) throws IOException, PageNotFoundException {
        Preconditions.checkArgument(buffer != null, "buffer is null");
        Preconditions.checkArgument(pageOffset >= 0, "page offset should be non-negative");
        Preconditions.checkArgument(buffer.length >= bufferOffset, "page offset %s should be less or equal than buffer length %s", bufferOffset, buffer.length);
        PageId pageKey = this.getKeyFromPageId(pageId);
        if (!this.mPageStoreMap.containsKey(pageKey)) {
            throw new PageNotFoundException(pageId.getFileId() + "_" + pageId.getPageIndex());
        }
        byte[] page = this.mPageStoreMap.get(pageKey);
        Preconditions.checkArgument(pageOffset <= page.length, "page offset %s exceeded page size %s", pageOffset, page.length);
        int bytesLeft = Math.min(page.length - pageOffset, buffer.length - bufferOffset);
        bytesLeft = Math.min(bytesLeft, bytesToRead);
        System.arraycopy(page, pageOffset, buffer, bufferOffset, bytesLeft);
        return bytesLeft;
    }

    @Override
    public void delete(PageId pageId) throws IOException, PageNotFoundException {
        PageId pageKey = this.getKeyFromPageId(pageId);
        if (!this.mPageStoreMap.containsKey(pageKey)) {
            throw new PageNotFoundException(pageId.getFileId() + "_" + pageId.getPageIndex());
        }
        this.mPageStoreMap.remove(pageKey);
        LOG.info("Remove cached page, size: {}", (Object)this.mPageStoreMap.size());
    }

    @VisibleForTesting
    public PageId getKeyFromPageId(PageId pageId) {
        return pageId;
    }

    @Override
    public void close() {
        this.mPageStoreMap.clear();
        this.mPageStoreMap = null;
    }

    public void reset() {
        this.mPageStoreMap.clear();
    }
}

