/*
 * Decompiled with CFR 0.152.
 */
package alluxio.exception;

import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.FailedPreconditionRuntimeException;
import alluxio.exception.status.InvalidArgumentRuntimeException;
import alluxio.exception.status.NotFoundRuntimeException;
import alluxio.exception.status.UnauthenticatedRuntimeException;
import alluxio.exception.status.UnknownRuntimeException;
import alluxio.grpc.ErrorInfo;
import alluxio.grpc.ErrorType;
import alluxio.grpc.RetryInfo;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.Any;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusException;
import alluxio.shaded.client.io.grpc.protobuf.ProtoUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.concurrent.CompletionException;
import javax.security.sasl.SaslException;

public class AlluxioRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 7801880681732804395L;
    private final Status mStatus;
    private final Any[] mDetails;
    private final boolean mRetryable;
    private final ErrorType mErrorType;

    public AlluxioRuntimeException(Status status, String message, ErrorType errorType, boolean retryable) {
        this(status, message, null, errorType, retryable, new Any[0]);
    }

    public AlluxioRuntimeException(String message) {
        this(Status.UNKNOWN, message, null, ErrorType.User, false, new Any[0]);
    }

    public AlluxioRuntimeException(Status status, Throwable cause, ErrorType errorType) {
        this(status, null, cause, errorType, false, new Any[0]);
    }

    public AlluxioRuntimeException(Status status, String message, Throwable cause, ErrorType errorType, boolean retryable, Any ... details) {
        super(message, cause);
        Preconditions.checkNotNull(status, "status");
        Preconditions.checkArgument(status != Status.OK, "OK is not an error status");
        this.mStatus = status.withCause(cause).withDescription(message);
        this.mDetails = details;
        this.mRetryable = retryable;
        this.mErrorType = errorType;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean isRetryable() {
        return this.mRetryable;
    }

    public StatusException toGrpcStatusException() {
        Metadata trailers = new Metadata();
        trailers.put(ProtoUtils.keyForProto(RetryInfo.getDefaultInstance()), RetryInfo.newBuilder().setIsRetryable(this.mRetryable).build());
        trailers.put(ProtoUtils.keyForProto(ErrorInfo.getDefaultInstance()), ErrorInfo.newBuilder().setErrorType(this.mErrorType).build());
        if (this.mDetails != null) {
            trailers = new Metadata();
            for (Any detail : this.mDetails) {
                trailers.put(ProtoUtils.keyForProto(Any.getDefaultInstance()), detail);
            }
        }
        return this.mStatus.withCause(this.getCause()).withDescription(this.getMessage()).asException(trailers);
    }

    public static AlluxioRuntimeException from(Throwable t) {
        if (t instanceof AlluxioRuntimeException) {
            return (AlluxioRuntimeException)t;
        }
        if (t instanceof AlluxioStatusException) {
            return AlluxioRuntimeException.from((AlluxioStatusException)t);
        }
        if (t instanceof IOException) {
            return AlluxioRuntimeException.from((IOException)t);
        }
        if (t instanceof RuntimeException) {
            return AlluxioRuntimeException.from((RuntimeException)t);
        }
        return new UnknownRuntimeException(t);
    }

    public static AlluxioRuntimeException from(AlluxioRuntimeException t) {
        return t;
    }

    public static AlluxioRuntimeException from(RuntimeException t) {
        if (t instanceof IllegalArgumentException) {
            return new InvalidArgumentRuntimeException(t);
        }
        if (t instanceof IllegalStateException) {
            return new FailedPreconditionRuntimeException(t);
        }
        if (t instanceof CompletionException) {
            return AlluxioRuntimeException.from(t.getCause());
        }
        return new UnknownRuntimeException(t);
    }

    public static AlluxioRuntimeException from(AlluxioStatusException t) {
        return new AlluxioRuntimeException(t.getStatus(), t.getMessage(), t.getCause(), ErrorType.User, false, new Any[0]);
    }

    public static AlluxioRuntimeException from(IOException ioe) {
        if (ioe instanceof FileNotFoundException) {
            return new NotFoundRuntimeException(ioe);
        }
        if (ioe instanceof MalformedURLException) {
            return new InvalidArgumentRuntimeException(ioe);
        }
        if (ioe instanceof UserPrincipalNotFoundException || ioe instanceof SaslException) {
            return new UnauthenticatedRuntimeException(ioe);
        }
        if (ioe instanceof ClosedChannelException) {
            return new FailedPreconditionRuntimeException(ioe);
        }
        return new UnknownRuntimeException(ioe);
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message == null) {
            message = this.mStatus.getDescription();
        }
        return message;
    }
}

