/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NotThreadSafe
public final class UnderFileSystemConfiguration
implements AlluxioConfiguration {
    private final boolean mReadOnly;
    private final AlluxioConfiguration mAlluxioConf;
    private static final UnderFileSystemConfiguration EMPTY_CONFIG = new UnderFileSystemConfiguration(new InstancedConfiguration(new AlluxioProperties()), false);

    public static UnderFileSystemConfiguration defaults(AlluxioConfiguration alluxioConf) {
        return new UnderFileSystemConfiguration(alluxioConf, false);
    }

    public static UnderFileSystemConfiguration emptyConfig() {
        return EMPTY_CONFIG;
    }

    public UnderFileSystemConfiguration(AlluxioConfiguration alluxioConf, boolean readOnly) {
        this.mAlluxioConf = alluxioConf;
        this.mReadOnly = readOnly;
    }

    public Map<String, Object> getMountSpecificConf() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.keySet().forEach(key -> {
            if (this.getSource((PropertyKey)key) == Source.MOUNT_OPTION) {
                map.put(key.getName(), this.get((PropertyKey)key));
            }
        });
        return map;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public UnderFileSystemConfiguration createMountSpecificConf(Map<String, ? extends Object> mountConf) {
        AlluxioProperties properties = this.copyProperties();
        properties.merge(mountConf, Source.MOUNT_OPTION);
        return new UnderFileSystemConfiguration(new InstancedConfiguration(properties), this.mReadOnly);
    }

    public Map<String, String> toUserPropertyMap(ConfigurationValueOptions options) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.userKeySet().forEach(key -> {
            Object value = this.getOrDefault((PropertyKey)key, null, options);
            map.put(key.getName(), value == null ? null : String.valueOf(value));
        });
        return map;
    }

    @Override
    public Object get(PropertyKey key) {
        return this.mAlluxioConf.get(key);
    }

    @Override
    public Object get(PropertyKey key, ConfigurationValueOptions options) {
        return this.mAlluxioConf.get(key, options);
    }

    @Override
    public boolean isSet(PropertyKey key) {
        return this.mAlluxioConf.isSet(key);
    }

    @Override
    public boolean isSetByUser(PropertyKey key) {
        return this.mAlluxioConf.isSetByUser(key);
    }

    @Override
    public Set<PropertyKey> keySet() {
        return this.mAlluxioConf.keySet();
    }

    @Override
    public Set<PropertyKey> userKeySet() {
        return this.mAlluxioConf.userKeySet();
    }

    @Override
    public String getString(PropertyKey key) {
        return this.mAlluxioConf.getString(key);
    }

    @Override
    public int getInt(PropertyKey key) {
        return this.mAlluxioConf.getInt(key);
    }

    @Override
    public double getDouble(PropertyKey key) {
        return this.mAlluxioConf.getDouble(key);
    }

    @Override
    public boolean getBoolean(PropertyKey key) {
        return this.mAlluxioConf.getBoolean(key);
    }

    @Override
    public List<String> getList(PropertyKey key) {
        return this.mAlluxioConf.getList(key);
    }

    @Override
    public <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        return this.mAlluxioConf.getEnum(key, enumType);
    }

    @Override
    public long getBytes(PropertyKey key) {
        return this.mAlluxioConf.getBytes(key);
    }

    @Override
    public long getMs(PropertyKey key) {
        return this.mAlluxioConf.getMs(key);
    }

    @Override
    public Duration getDuration(PropertyKey key) {
        return this.mAlluxioConf.getDuration(key);
    }

    @Override
    public <T> Class<T> getClass(PropertyKey key) {
        return this.mAlluxioConf.getClass(key);
    }

    @Override
    public Map<String, Object> getNestedProperties(PropertyKey prefixKey) {
        return this.mAlluxioConf.getNestedProperties(prefixKey);
    }

    @Override
    public AlluxioProperties copyProperties() {
        return this.mAlluxioConf.copyProperties();
    }

    @Override
    public Source getSource(PropertyKey key) {
        return this.mAlluxioConf.getSource(key);
    }

    @Override
    public Map<String, Object> toMap(ConfigurationValueOptions opts) {
        return this.mAlluxioConf.toMap(opts);
    }

    @Override
    public void validate() {
        this.mAlluxioConf.validate();
    }

    @Override
    public boolean clusterDefaultsLoaded() {
        return this.mAlluxioConf.clusterDefaultsLoaded();
    }
}

