/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;

public class FileSystemOptions {
    private final boolean mMetadataCacheEnabled;
    private final boolean mDataCacheEnabled;

    public static FileSystemOptions create(AlluxioConfiguration conf) {
        return Builder.create(conf).build();
    }

    public static FileSystemOptions defaults() {
        return new Builder().build();
    }

    private FileSystemOptions(boolean metadaCacheEnabled, boolean dataCacheEnabled) {
        this.mMetadataCacheEnabled = metadaCacheEnabled;
        this.mDataCacheEnabled = dataCacheEnabled;
    }

    public boolean isMetadataCacheEnabled() {
        return this.mMetadataCacheEnabled;
    }

    public boolean isDataCacheEnabled() {
        return this.mDataCacheEnabled;
    }

    public static final class Builder {
        private boolean mMetadataCacheEnabled;
        private boolean mDataCacheEnabled;

        public static Builder create(AlluxioConfiguration conf) {
            return new Builder().setMetadataCacheEnabled(conf.getBoolean(PropertyKey.USER_METADATA_CACHE_ENABLED)).setDataCacheEnabled(conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ENABLED));
        }

        public Builder setMetadataCacheEnabled(boolean metadataCacheEnabled) {
            this.mMetadataCacheEnabled = metadataCacheEnabled;
            return this;
        }

        public Builder setDataCacheEnabled(boolean dataCacheEnabled) {
            this.mDataCacheEnabled = dataCacheEnabled;
            return this;
        }

        public FileSystemOptions build() {
            return new FileSystemOptions(this.mMetadataCacheEnabled, this.mDataCacheEnabled);
        }
    }
}

