/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.retry.ExponentialTimeBoundedRetry;
import alluxio.retry.RetryPolicy;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtils.class);

    public static void retry(String action, RunnableThrowsIOException f, RetryPolicy policy) throws IOException {
        IOException e = null;
        while (policy.attempt()) {
            try {
                f.run();
                return;
            }
            catch (IOException ioe) {
                e = ioe;
                LOG.warn("Failed to {} (attempt {}): {}", new Object[]{action, policy.getAttemptCount(), e.toString()});
            }
        }
        throw e;
    }

    public static <V> V retryCallable(String description, Callable<V> f, RetryPolicy policy) {
        Exception cause = null;
        while (policy.attempt()) {
            try {
                return f.call();
            }
            catch (Exception e) {
                LOG.warn("Failed to {} (attempt {}): {}", new Object[]{description, policy.getAttemptCount(), e.toString()});
                if (e instanceof AlluxioRuntimeException && !((AlluxioRuntimeException)e).isRetryable()) {
                    throw AlluxioRuntimeException.from(e);
                }
                cause = e;
            }
        }
        throw AlluxioRuntimeException.from(cause);
    }

    public static RetryPolicy defaultClientRetry() {
        return ExponentialTimeBoundedRetry.builder().withMaxDuration(Configuration.getDuration(PropertyKey.USER_RPC_RETRY_MAX_DURATION)).withInitialSleep(Configuration.getDuration(PropertyKey.USER_RPC_RETRY_BASE_SLEEP_MS)).withMaxSleep(Configuration.getDuration(PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS)).build();
    }

    public static RetryPolicy defaultWorkerMasterClientRetry() {
        return ExponentialTimeBoundedRetry.builder().withMaxDuration(Configuration.getDuration(PropertyKey.WORKER_MASTER_CONNECT_RETRY_TIMEOUT)).withInitialSleep(Duration.ofMillis(100L)).withMaxSleep(Duration.ofSeconds(5L)).build();
    }

    private RetryUtils() {
    }

    @FunctionalInterface
    public static interface RunnableThrowsIOException {
        public void run() throws IOException;
    }
}

