/*
 * Copyright (c) 2007-2013 Amazon.alluxio.shaded.client.com. Inc.  All rights reserved.
 */

package software.amazon.alluxio.shaded.client.io..util;

import software.amazon.alluxio.shaded.client.io..IonBlob;
import software.amazon.alluxio.shaded.client.io..IonBool;
import software.amazon.alluxio.shaded.client.io..IonClob;
import software.amazon.alluxio.shaded.client.io..IonDatagram;
import software.amazon.alluxio.shaded.client.io..IonDecimal;
import software.amazon.alluxio.shaded.client.io..IonFloat;
import software.amazon.alluxio.shaded.client.io..IonInt;
import software.amazon.alluxio.shaded.client.io..IonList;
import software.amazon.alluxio.shaded.client.io..IonNull;
import software.amazon.alluxio.shaded.client.io..IonSexp;
import software.amazon.alluxio.shaded.client.io..IonString;
import software.amazon.alluxio.shaded.client.io..IonStruct;
import software.amazon.alluxio.shaded.client.io..IonSymbol;
import software.amazon.alluxio.shaded.client.io..IonTimestamp;
import software.amazon.alluxio.shaded.client.io..IonValue;
import software.amazon.alluxio.shaded.client.io..ValueVisitor;

/**
 * A base class for extending Ion {@link ValueVisitor}s.
 * All <code>visit</code> methods are implemented to call
 * {@link #defaultVisit(IonValue)}.
 */
public abstract class AbstractValueVisitor
    implements ValueVisitor
{

    /**
     * Default visitation behavior, called by all <code>visit</code> methods
     * in {@link AbstractValueVisitor}.  Subclasses should override this unless
     * they override all <code>visit</code> methods.
     * <p>
     * This implementation always throws {@link UnsupportedOperationException}.
     *
     * @param value the value to visit.
     * @throws UnsupportedOperationException always thrown unless subclass
     * overrides this implementation.
     * @throws Exception subclasses can throw this; it will be propagated by
     * the other <code>visit</code> methods.
     */
    protected void defaultVisit(IonValue value) throws Exception
    {
        throw new UnsupportedOperationException();
    }

    public void visit(IonBlob value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonBool value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonClob value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonDatagram value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonDecimal value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonFloat value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonInt value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonList value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonNull value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonSexp value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonString value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonStruct value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonSymbol value) throws Exception
    {
        defaultVisit(value);
    }

    public void visit(IonTimestamp value) throws Exception
    {
        defaultVisit(value);
    }
}
