/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockOutStream;
import alluxio.client.block.stream.DataWriter;
import alluxio.client.block.stream.GrpcDataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.grpc.RequestType;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;

@NotThreadSafe
public class UnderFileSystemFileOutStream
extends BlockOutStream {
    private static final int ID_UNUSED = -1;

    public static UnderFileSystemFileOutStream create(FileSystemContext context, WorkerNetAddress address, OutStreamOptions options) throws IOException {
        return new UnderFileSystemFileOutStream(GrpcDataWriter.create(context, address, -1L, Long.MAX_VALUE, RequestType.UFS_FILE, options), address);
    }

    protected UnderFileSystemFileOutStream(DataWriter dataWriter, WorkerNetAddress address) {
        super(dataWriter, Long.MAX_VALUE, address);
    }

    @Override
    public void close() throws IOException {
        try (Timer.Context ctx = MetricsSystem.uniformTimer(MetricKey.CLOSE_UFS_OUTSTREAM_LATENCY.getName()).time();){
            super.close();
        }
    }
}

