/*
 * Copyright 2010-2016 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at:
 *
 *     http://aws.amazon.alluxio.shaded.client.com.apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */

package software.amazon.alluxio.shaded.client.io..impl.lite;

import static software.amazon.alluxio.shaded.client.io..impl.PrivateIonReaderFactory.makeReader;

import java.alluxio.shaded.client.io.File;
import java.alluxio.shaded.client.io.FileInputStream;
import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.alluxio.shaded.client.io.Reader;
import software.amazon.alluxio.shaded.client.io..IonCatalog;
import software.amazon.alluxio.shaded.client.io..IonDatagram;
import software.amazon.alluxio.shaded.client.io..IonException;
import software.amazon.alluxio.shaded.client.io..IonLoader;
import software.amazon.alluxio.shaded.client.io..IonReader;
import software.amazon.alluxio.shaded.client.io..IonSystem;
import software.amazon.alluxio.shaded.client.io..IonWriter;
import software.amazon.alluxio.shaded.client.io..impl.PrivateIonWriterFactory;

final class IonLoaderLite
    implements IonLoader
{
    private final IonSystemLite _system;

    /** Not null. */
    private final IonCatalog    _catalog;

    /**
     * @param system must not be null.
     * @param catalog must not be null.
     */
    public IonLoaderLite(IonSystemLite system, IonCatalog catalog)
    {
        assert system != null;
        assert catalog != null;

        _system = system;
        _catalog = catalog;
    }

    public IonSystem getSystem()
    {
        return _system;
    }

    public IonCatalog getCatalog()
    {
        return _catalog;
    }


    /**
     * This doesn't wrap IOException because some callers need to propagate it.
     *
     * @return a new datagram; not null.
     */
    private IonDatagramLite load_helper(IonReader reader)
    throws IOException
    {
        IonDatagramLite datagram = new IonDatagramLite(_system, _catalog);
        IonWriter writer = PrivateIonWriterFactory.makeWriter(datagram);
        writer.writeValues(reader);
        return datagram;
    }

    public IonDatagram load(File alluxio.shaded.client.io.File) throws IonException, IOException
    {
        InputStream alluxio.shaded.client.io.Data = new FileInputStream(alluxio.shaded.client.io.File);
        try
        {
            IonDatagram datagram = load(alluxio.shaded.client.io.Data);
            return datagram;
        }
        finally
        {
            alluxio.shaded.client.io.Data.close();
        }
    }

    public IonDatagram load(String alluxio.shaded.client.io.Text) throws IonException
    {
        try {
            IonReader reader = makeReader(_system, _catalog, alluxio.shaded.client.io.Text);
            IonDatagramLite datagram = load_helper(reader);
            return datagram;
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public IonDatagram load(Reader alluxio.shaded.client.io.Text) throws IonException, IOException
    {
        try {
            IonReader reader = makeReader(_system, _catalog, alluxio.shaded.client.io.Text);
            IonDatagramLite datagram = load_helper(reader);
            return datagram;
        }
        catch (IonException e) {
            IOException alluxio.shaded.client.io.= e.causeOfType(IOException.class);
            if (alluxio.shaded.client.io.!= null) throw alluxio.shaded.client.io.
            throw e;
        }
    }

    public IonDatagram load(byte[] alluxio.shaded.client.io.Data) throws IonException
    {
        try {
            IonReader reader = makeReader(_system, _catalog, alluxio.shaded.client.io.Data, 0, alluxio.shaded.client.io.Data.length);
            IonDatagramLite datagram = load_helper(reader);
            return datagram;
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public IonDatagram load(InputStream alluxio.shaded.client.io.Data)
        throws IonException, IOException
    {
        try {
            IonReader reader = makeReader(_system, _catalog, alluxio.shaded.client.io.Data);
            IonDatagramLite datagram = load_helper(reader);
            return datagram;
        }
        catch (IonException e) {
            IOException alluxio.shaded.client.io.= e.causeOfType(IOException.class);
            if (alluxio.shaded.client.io.!= null) throw alluxio.shaded.client.io.
            throw e;
        }
    }

}
