/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.auth;

import alluxio.shaded.client.com.amazonaws.SdkClientException;
import alluxio.shaded.client.com.amazonaws.annotation.SdkInternalApi;
import alluxio.shaded.client.com.amazonaws.annotation.SdkTestInternalApi;
import alluxio.shaded.client.com.amazonaws.auth.BaseCredentialsFetcher;
import alluxio.shaded.client.com.amazonaws.internal.EC2ResourceFetcher;
import alluxio.shaded.client.com.amazonaws.internal.InstanceMetadataServiceResourceFetcher;
import alluxio.shaded.client.com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import alluxio.shaded.client.com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import alluxio.shaded.client.com.amazonaws.util.EC2MetadataUtils;
import java.net.URI;

@SdkInternalApi
final class InstanceMetadataServiceCredentialsFetcher
extends BaseCredentialsFetcher
implements CredentialsEndpointRetryPolicy {
    private final EC2ResourceFetcher resourceFetcher;

    InstanceMetadataServiceCredentialsFetcher() {
        this.resourceFetcher = InstanceMetadataServiceResourceFetcher.getInstance();
    }

    @SdkTestInternalApi
    InstanceMetadataServiceCredentialsFetcher(EC2ResourceFetcher resourceFetcher) {
        this.resourceFetcher = resourceFetcher;
    }

    @Override
    protected String getCredentialsResponse() {
        URI credentialsEndpoint = this.getCredentialsEndpoint();
        return this.resourceFetcher.readResource(credentialsEndpoint, this);
    }

    @Override
    public String toString() {
        return "InstanceMetadataServiceCredentialsFetcher";
    }

    private URI getCredentialsEndpoint() {
        String host = EC2MetadataUtils.getHostAddressForEC2MetadataService();
        String securityCredentialsList = this.resourceFetcher.readResource(URI.create(host + "/latest/meta-data/iam/security-credentials/"), this);
        String[] securityCredentials = securityCredentialsList.trim().split("\n");
        if (securityCredentials.length == 0) {
            throw new SdkClientException("Unable to load credentials path");
        }
        return URI.create(host + "/latest/meta-data/iam/security-credentials/" + securityCredentials[0]);
    }

    @Override
    public boolean shouldRetry(int retriesAttempted, CredentialsEndpointRetryParameters retryParams) {
        return false;
    }
}

