/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionsystem;

import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionIonSystem;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonBinaryWriterBuilder;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;
import alluxio.shaded.client.software.amazon.ionimpl.lite.PrivateLiteDomTrampoline;
import alluxio.shaded.client.software.amazon.ionsystem.IonTextWriterBuilder;
import alluxio.shaded.client.software.amazon.ionsystem.SimpleCatalog;

public class IonSystemBuilder {
    private static final IonSystemBuilder STANDARD = new IonSystemBuilder();
    ionIonCatalog myCatalog;
    boolean myStreamCopyOptimized = false;

    public static IonSystemBuilder standard() {
        return STANDARD;
    }

    private IonSystemBuilder() {
    }

    private IonSystemBuilder(IonSystemBuilder that) {
        this.myCatalog = that.myCatalog;
        this.myStreamCopyOptimized = that.myStreamCopyOptimized;
    }

    public final IonSystemBuilder copy() {
        return new Mutable(this);
    }

    public IonSystemBuilder immutable() {
        return this;
    }

    public IonSystemBuilder mutable() {
        return this.copy();
    }

    void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public final ionIonCatalog getCatalog() {
        return this.myCatalog;
    }

    public final void setCatalog(ionIonCatalog catalog) {
        this.mutationCheck();
        this.myCatalog = catalog;
    }

    public final IonSystemBuilder withCatalog(ionIonCatalog catalog) {
        IonSystemBuilder b = this.mutable();
        b.setCatalog(catalog);
        return b;
    }

    public final boolean isStreamCopyOptimized() {
        return this.myStreamCopyOptimized;
    }

    public final void setStreamCopyOptimized(boolean optimized) {
        this.mutationCheck();
        this.myStreamCopyOptimized = optimized;
    }

    public final IonSystemBuilder withStreamCopyOptimized(boolean optimized) {
        IonSystemBuilder b = this.mutable();
        b.setStreamCopyOptimized(optimized);
        return b;
    }

    public final ionIonSystem build() {
        ionIonCatalog catalog = this.myCatalog != null ? this.myCatalog : new SimpleCatalog();
        IonTextWriterBuilder twb = IonTextWriterBuilder.standard().withCharsetAscii();
        twb.setCatalog(catalog);
        PrivateIonBinaryWriterBuilder bwb = PrivateIonBinaryWriterBuilder.standard();
        bwb.setCatalog(catalog);
        bwb.setStreamCopyOptimized(this.myStreamCopyOptimized);
        ionSymbolTable systemSymtab = PrivateUtils.systemSymtab(1);
        bwb.setInitialSymbolTable(systemSymtab);
        return PrivateLiteDomTrampoline.newLiteSystem(twb, bwb);
    }

    private static final class Mutable
    extends IonSystemBuilder {
        private Mutable(IonSystemBuilder that) {
            super(that);
        }

        public IonSystemBuilder immutable() {
            return new IonSystemBuilder(this);
        }

        public IonSystemBuilder mutable() {
            return this;
        }

        void mutationCheck() {
        }
    }
}

